/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.acl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Owner;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 8095040648034788376L;
    public static final AccessControlList REST_CANNED_PRIVATE = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_WRITE = new AccessControlList();
    public static final AccessControlList REST_CANNED_AUTHENTICATED_READ = new AccessControlList();
    private HashSet grants = new HashSet();
    private S3Owner owner = null;

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrants() + "]";
    }

    public S3Owner getOwner() {
        return this.owner;
    }

    public void setOwner(S3Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(GranteeInterface grantee, Permission permission) {
        this.grants.add(new GrantAndPermission(grantee, permission));
    }

    public void grantAllPermissions(Set grants) {
        for (GrantAndPermission gap : grants) {
            this.grantPermission(gap.getGrantee(), gap.getPermission());
        }
    }

    public void revokeAllPermissions(GranteeInterface grantee) {
        ArrayList<GrantAndPermission> grantsToRemove = new ArrayList<GrantAndPermission>();
        for (GrantAndPermission gap : this.grants) {
            if (!gap.getGrantee().equals(grantee)) continue;
            grantsToRemove.add(gap);
        }
        this.grants.removeAll(grantsToRemove);
    }

    public Set getGrants() {
        return this.grants;
    }

    public String toXml() throws S3ServiceException {
        if (this.owner == null) {
            throw new S3ServiceException("Invalid AccessControlList: missing an S3Owner");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<AccessControlPolicy xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Owner><ID>" + this.owner.getId() + "</ID>" + "<DisplayName>" + this.owner.getDisplayName() + "</DisplayName>" + "</Owner>" + "<AccessControlList>");
        for (GrantAndPermission gap : this.grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            sb.append("<Grant>" + grantee.toXml() + "<Permission>" + permission + "</Permission>" + "</Grant>");
        }
        sb.append("</AccessControlList></AccessControlPolicy>");
        return sb.toString();
    }

    public boolean isCannedRestACL() {
        return this.equals(REST_CANNED_AUTHENTICATED_READ) || this.equals(REST_CANNED_PRIVATE) || this.equals(REST_CANNED_PUBLIC_READ) || this.equals(REST_CANNED_PUBLIC_READ_WRITE);
    }
}

