/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class CloudFrontXmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(CloudFrontXmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private Jets3tProperties properties = null;

    public CloudFrontXmlResponsesSaxParser(Jets3tProperties properties) throws S3ServiceException {
        this.properties = properties;
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new S3ServiceException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws CloudFrontServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new CloudFrontServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    public ListDistributionListHandler parseDistributionListResponse(InputStream inputStream) throws CloudFrontServiceException {
        ListDistributionListHandler handler = new ListDistributionListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionHandler parseDistributionResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionHandler handler = new DistributionHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionConfigHandler parseDistributionConfigResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionConfigHandler handler = new DistributionConfigHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ErrorHandler parseErrorResponse(InputStream inputStream) throws CloudFrontServiceException {
        ErrorHandler handler = new ErrorHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public class ErrorHandler
    extends SimpleHandler {
        private String type;
        private String code;
        private String message;
        private String detail;
        private String requestId;

        public ErrorHandler() {
            this.type = null;
            this.code = null;
            this.message = null;
            this.detail = null;
            this.requestId = null;
        }

        public String getCode() {
            return this.code;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getMessage() {
            return this.message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getType() {
            return this.type;
        }

        public void endType(String text) {
            this.type = text;
        }

        public void endCode(String text) {
            this.code = text;
        }

        public void endMessage(String text) {
            this.message = text;
        }

        public void endDetail(String text) {
            this.detail = text;
        }

        public void endRequestId(String text) {
            this.requestId = text;
        }

        public void endRequestID(String text) {
            this.requestId = text;
        }
    }

    public class ListDistributionListHandler
    extends SimpleHandler {
        private List distributions;
        private List cnamesList;
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;

        public ListDistributionListHandler() {
            this.distributions = new ArrayList();
            this.cnamesList = new ArrayList();
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
        }

        public List getDistributions() {
            return this.distributions;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void startDistributionSummary() {
            this.transferControlToHandler(new DistributionSummaryHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            this.distributions.add(((DistributionSummaryHandler)childHandler).getDistribution());
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = "true".equalsIgnoreCase(text);
        }
    }

    public class DistributionSummaryHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private String domainName;
        private String origin;
        private List cnamesList;
        private String comment;
        private boolean enabled;

        public DistributionSummaryHandler() {
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.domainName = null;
            this.origin = null;
            this.cnamesList = new ArrayList();
            this.comment = null;
            this.enabled = false;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void endOrigin(String text) {
            this.origin = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = "true".equalsIgnoreCase(text);
        }

        public void endDistributionSummary(String text) {
            this.distribution = new Distribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.origin, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled);
            this.returnControlToParentHandler();
        }
    }

    public class DistributionConfigHandler
    extends SimpleHandler {
        private DistributionConfig distributionConfig;
        private String origin;
        private String callerReference;
        private List cnamesList;
        private String comment;
        private boolean enabled;
        private LoggingStatus loggingStatus;

        public DistributionConfigHandler() {
            this.distributionConfig = null;
            this.origin = null;
            this.callerReference = null;
            this.cnamesList = new ArrayList();
            this.comment = null;
            this.enabled = false;
            this.loggingStatus = null;
        }

        public DistributionConfig getDistributionConfig() {
            return this.distributionConfig;
        }

        public void endOrigin(String text) {
            this.origin = text;
        }

        public void endCallerReference(String text) {
            this.callerReference = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = "true".equalsIgnoreCase(text);
        }

        public void startLogging() {
            this.loggingStatus = new LoggingStatus();
        }

        public void endBucket(String text) {
            this.loggingStatus.setBucket(text);
        }

        public void endPrefix(String text) {
            this.loggingStatus.setPrefix(text);
        }

        public void endDistributionConfig(String text) {
            this.distributionConfig = new DistributionConfig(this.origin, this.callerReference, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, this.loggingStatus);
            this.returnControlToParentHandler();
        }
    }

    public class DistributionHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private String domainName;

        public DistributionHandler() {
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.domainName = null;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void startDistributionConfig() {
            this.transferControlToHandler(new DistributionConfigHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            DistributionConfig config = ((DistributionConfigHandler)childHandler).getDistributionConfig();
            this.distribution = new Distribution(this.id, this.status, this.lastModifiedTime, this.domainName, config);
        }

        public void endDistribution(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class SimpleHandler
    extends DefaultHandler {
        private StringBuffer textContent = new StringBuffer();
        protected SimpleHandler currentHandler = this;
        protected SimpleHandler parentHandler = null;

        public void transferControlToHandler(SimpleHandler toHandler) {
            this.currentHandler = toHandler;
            toHandler.parentHandler = this;
        }

        public void returnControlToParentHandler() {
            if (this.isChildHandler()) {
                this.parentHandler.currentHandler = this.parentHandler;
                this.parentHandler.controlReturned(this);
            } else {
                log.debug((Object)("Ignoring call to return control to parent handler, as this class has no parent: " + this.getClass().getName()));
            }
        }

        public boolean isChildHandler() {
            return this.parentHandler != null;
        }

        public void controlReturned(SimpleHandler childHandler) {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            try {
                Method method = this.currentHandler.getClass().getMethod("start" + name, new Class[0]);
                method.invoke((Object)this.currentHandler, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)("Skipped non-existent SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName()));
            }
            catch (Throwable t) {
                log.error((Object)("Unable to invoke SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName()), t);
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.textContent.toString().trim();
            try {
                Method method = this.currentHandler.getClass().getMethod("end" + name, String.class);
                method.invoke((Object)this.currentHandler, elementText);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)("Skipped non-existent SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName()));
            }
            catch (Throwable t) {
                log.error((Object)("Unable to invoke SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName()), t);
            }
            this.textContent = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.textContent.append(ch, start, length);
        }
    }
}

