/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jets3t.service.acl.GrantAndPermission;

public class S3BucketLoggingStatus {
    private String targetBucketName = null;
    private String logfilePrefix = null;
    private List targetGrantsList = new ArrayList();

    public S3BucketLoggingStatus() {
    }

    public S3BucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null && this.logfilePrefix != null;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public GrantAndPermission[] getTargetGrants() {
        return this.targetGrantsList.toArray(new GrantAndPermission[this.targetGrantsList.size()]);
    }

    public void setTargetGrants(GrantAndPermission[] targetGrants) {
        this.targetGrantsList.clear();
        this.targetGrantsList.addAll(Arrays.asList(targetGrants));
    }

    public void addTargetGrant(GrantAndPermission targetGrant) {
        this.targetGrantsList.add(targetGrant);
    }

    public String toString() {
        String result = "LoggingStatus enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result = result + ", targetBucketName=" + this.getTargetBucketName() + ", logfilePrefix=" + this.getLogfilePrefix();
        }
        result = result + ", targetGrants=[" + this.targetGrantsList + "]";
        return result;
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<BucketLoggingStatus xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">");
        if (this.isLoggingEnabled()) {
            sb.append("<LoggingEnabled><TargetBucket>" + this.getTargetBucketName() + "</TargetBucket>" + "<TargetPrefix>" + this.getLogfilePrefix() + "</TargetPrefix>");
            if (this.targetGrantsList.size() > 0) {
                Iterator targetGrantsIter = this.targetGrantsList.iterator();
                sb.append("<TargetGrants>");
                while (targetGrantsIter.hasNext()) {
                    GrantAndPermission gap = (GrantAndPermission)targetGrantsIter.next();
                    sb.append("<Grant>" + gap.getGrantee().toXml() + "<Permission>" + gap.getPermission() + "</Permission>" + "</Grant>");
                }
                sb.append("</TargetGrants>");
            }
            sb.append("</LoggingEnabled>");
        }
        sb.append("</BucketLoggingStatus>");
        return sb.toString();
    }
}

