/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.mx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.mx.MxInterface;

public class MxDelegate
implements MxInterface {
    private static final Log log = LogFactory.getLog(MxDelegate.class);
    private MxInterface handler = null;
    private static MxDelegate instance = null;

    public static MxDelegate getInstance() {
        if (instance == null) {
            instance = new MxDelegate();
        }
        return instance;
    }

    protected MxDelegate() {
    }

    public void init() {
        if (System.getProperty("com.sun.management.jmxremote") == null && System.getProperty("jets3t.mx") == null) {
            this.handler = null;
            return;
        }
        try {
            Class<?> impl = Class.forName("contribs.mx.MxImpl");
            this.handler = (MxInterface)impl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"JMX instrumentation package 'contribs.mx' could not be found,  instrumentation will not available", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"JMX instrumentation implementation in package 'contribs.mx'  could not be loaded", (Throwable)e);
        }
    }

    public boolean isJmxDelegationActive() {
        return this.handler != null;
    }

    public void registerS3ServiceMBean() {
        if (this.handler != null) {
            this.handler.registerS3ServiceMBean();
        }
    }

    public void registerS3ServiceExceptionMBean() {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionMBean();
        }
    }

    public void registerS3ServiceExceptionEvent() {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionEvent();
        }
    }

    public void registerS3ServiceExceptionEvent(String s3ErrorCode) {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionEvent(s3ErrorCode);
        }
    }

    public void registerS3BucketMBeans(S3Bucket[] buckets) {
        if (this.handler != null) {
            this.handler.registerS3BucketMBeans(buckets);
        }
    }

    public void registerS3BucketListEvent(String bucketName) {
        if (this.handler != null) {
            this.handler.registerS3BucketListEvent(bucketName);
        }
    }

    public void registerS3ObjectMBean(String bucketName, S3Object[] objects) {
        if (this.handler != null) {
            this.handler.registerS3ObjectMBean(bucketName, objects);
        }
    }

    public void registerS3ObjectPutEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerS3ObjectPutEvent(bucketName, key);
        }
    }

    public void registerS3ObjectGetEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerS3ObjectGetEvent(bucketName, key);
        }
    }

    public void registerS3ObjectHeadEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerS3ObjectHeadEvent(bucketName, key);
        }
    }

    public void registerS3ObjectDeleteEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerS3ObjectDeleteEvent(bucketName, key);
        }
    }

    public void registerS3ObjectCopyEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerS3ObjectCopyEvent(bucketName, key);
        }
    }
}

