/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.apachecon.camel.filesplit;

import java.util.concurrent.CountDownLatch;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.ServiceSupport;


public final class SplitCounterProcessor extends ServiceSupport implements Processor, CamelContextAware {
	private CamelContext context;
	private CountDownLatch counter;
	private long timeStarted = 0;

	@Override
	public void setCamelContext(CamelContext camelContext) {
		this.context = camelContext;
	}

	@Override
	public CamelContext getCamelContext() {
		return context;
	}

	@Override
	public void process(Exchange exchange) throws Exception {
		if (counter != null) {
		    counter.countDown();
		}
	}

	@Override
	protected void doStart() throws Exception {
		timeStarted = System.currentTimeMillis();
	}

	@Override
	protected void doStop() throws Exception {
	}

	public CountDownLatch getCounter() {
		return counter;
	}

	public void setCounter(CountDownLatch counter) {
		this.counter = counter;
	}

	public long getTimeStarted() {
		return timeStarted;
	}
}
