/*****************************************************************
 *   File: FileRetrieverConnection.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.04,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.connector;

import java.io.FileNotFoundException;
import java.io.OutputStream;

import javax.resource.ResourceException;

/**
 * File Retriever connection interface
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public interface FileRetrieverConnection {

    /**
     * Retrieves file and writes its content to the output stream.
     * @param name name of the file to retrieve
     * @param stream output stream for writing the file content
     *     (opening and closing the stream is performed by client)
     * @throws ResourceException in case of any problem
     * @throws FileNotFoundException if the file is not found
     */
    public void retrieve(String name, OutputStream stream) 
        throws ResourceException, FileNotFoundException;
    
    /**
     * Retrieves names of files available in the repository
     * @return array of file names 
     * @throws ResourceException in case of any problem
     */
    public String[] listFiles() throws ResourceException;
    
    /**
     * Retrieves names of directories available in the repository
     * @return array of directory names 
     * @throws ResourceException in case of any problem
     */
    public String[] listDirectories() throws ResourceException;
    
    /**
     * Closes the connection and all opened file streams
     * @throws ResourceException in case of any problem
     */
    public void close() throws ResourceException;
}