/*****************************************************************
 *   File: FileRetrieverConnectionFactoryImpl.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.04,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.connector.impl;

import java.io.Serializable;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

import com.ibm.j2g.jca.connector.FileRetrieverConnection;
import com.ibm.j2g.jca.connector.FileRetrieverConnectionFactory;

/**
 * Implements File Retriever connection factory
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public class FileRetrieverConnectionFactoryImpl implements
        FileRetrieverConnectionFactory, Serializable, Referenceable {

    /** Managed connection factory */
    private ManagedConnectionFactory mcf;

    /** Connection manager */
    private ConnectionManager cm;

    /** JNDI reference */
    private Reference reference;

    /**
     * The constructor
     * @param factory managed connection factory
     * @param cm connection manager
     */
    public FileRetrieverConnectionFactoryImpl(ManagedConnectionFactory factory,
            ConnectionManager cm) {
        this.mcf = factory;
        this.cm = cm;
    }

    /*
     * @see com.ibm.testjca.TestConnectionFactory#getConnection()
     */
    public FileRetrieverConnection getConnection() throws ResourceException {
        return (FileRetrieverConnection) cm.allocateConnection(mcf, null);
    }

    /*
     * @see javax.resource.Referenceable#setReference(javax.naming.Reference)
     */
    public void setReference(Reference reference) {
        this.reference = reference;
    }

    /*
     * @see javax.naming.Referenceable#getReference()
     */
    public Reference getReference() throws NamingException {
        return reference;
    }
}
