/*****************************************************************
 *   File: FileRetrieverServlet.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.05,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.web;

import java.io.FileNotFoundException;
import java.io.IOException;

import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ibm.j2g.jca.connector.FileRetrieverConnection;
import com.ibm.j2g.jca.connector.FileRetrieverConnectionFactory;

/**
 * Servlet which serves contents of requested files
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public class FileRetrieverServlet extends HttpServlet {

    /** Name of the reference to the File Retriever connector described in the web.xml file */
    private final static String CONNECTOR_REF_NAME = "java:comp/env/ra/FileRetriever";

    /**
     * Returns connection to the File Retriever
     * @return File Retriever connection instance
     * @throws NamingException in case the File Retriever EIS is not found
     * @throws ResourceException in case of any problem with File Retriever
     */
    public FileRetrieverConnection getConnection() throws NamingException, ResourceException {
        javax.naming.InitialContext ctx = new javax.naming.InitialContext();
        FileRetrieverConnectionFactory factory = 
                (FileRetrieverConnectionFactory)ctx.lookup(CONNECTOR_REF_NAME);
        return factory.getConnection();
    }
    
    /*
     * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    protected void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        String file = request.getParameter("file");
        if (file == null) {
            response.sendError(HttpServletResponse.SC_BAD_REQUEST);
            return;
        }
        
        FileRetrieverConnection connection = null;
        try {
            connection = getConnection();
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment; filename=" + file);
            connection.retrieve(file, response.getOutputStream());
            
        } catch (FileNotFoundException fnfe) {
            response.sendError(HttpServletResponse.SC_NOT_FOUND);
            
        } catch (Exception e) {
            throw new ServletException(e);
        
        } finally {
            if (connection != null) {
                try {
                    connection.close();
                } catch (ResourceException re) {
                }
            }
        }
    }
    
}
