/*****************************************************************
 *   File: FileRetrieverConnectionImpl.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.04,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.connector.impl;

import java.io.FileNotFoundException;
import java.io.OutputStream;

import javax.resource.ResourceException;

import com.ibm.j2g.jca.connector.FileRetrieverConnection;

/**
 * Implements File Retriever connection
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public class FileRetrieverConnectionImpl implements FileRetrieverConnection {
    
    /** Underlying physical connection instance */
    private FileRetrieverManagedConnection mc;
    
    /**
     * The constructor
     * @param mc underlying physical connection instance
     */
    public FileRetrieverConnectionImpl(FileRetrieverManagedConnection mc) {
        this.mc = mc;
    }
    
    /**
     * Associates this handle with given underlying physical
     * connection instance
     * @param newMc underlying physical connection instance
     */
    public void associateConnection(FileRetrieverManagedConnection newMc) {
        this.mc.removeConnection(this);
        newMc.addConnection(this);
        this.mc = newMc;
    }

    /**
     * Invalidates the connection
     */
    public void invalidate() {
        mc = null;
    }

    /*
     * @see com.ibm.j2g.jca.FileRetrieverConnection#retrieve(java.lang.String, java.io.OutputStream)
     */
    public void retrieve(String name, OutputStream stream)
            throws ResourceException, FileNotFoundException {
        mc.retrieve(name, stream);
    }

    /*
     * @see com.ibm.j2g.jca.FileRetrieverConnection#listFiles()
     */
    public String[] listFiles() throws ResourceException {
        return mc.listFiles();
    }

    /*
     * @see com.ibm.j2g.jca.FileRetrieverConnection#listDirectories()
     */
    public String[] listDirectories() throws ResourceException {
        return mc.listDirectories();
    }
    
    /*
     * @see com.ibm.j2g.jca.FileRetrieverConnection#close()
     */
    public void close() throws ResourceException {
        mc.close(this);
    }
}
