/*****************************************************************
 *   File: FileRetrieverManagedConnectionFactory.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.04,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.connector.impl;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

/**
 * File Retriever managed connection factory
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public class FileRetrieverManagedConnectionFactory
        implements ManagedConnectionFactory {

    /** Log writer */
    private transient PrintWriter writer;

    /** Path to file system repository */
    private String repository;

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#createConnectionFactory(javax.resource.spi.ConnectionManager)
     */
    public Object createConnectionFactory(ConnectionManager cm)
            throws ResourceException {
        return new FileRetrieverConnectionFactoryImpl(this, cm);
    }

    /* 
     * @see javax.resource.spi.ManagedConnectionFactory#createConnectionFactory()
     */
    public Object createConnectionFactory() throws ResourceException {
        return new FileRetrieverConnectionFactoryImpl(this, null);
    }

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#createManagedConnection(javax.security.auth.Subject, javax.resource.spi.ConnectionRequestInfo)
     */
    public ManagedConnection createManagedConnection(
            Subject subj,
            ConnectionRequestInfo conReqInfo)
            throws ResourceException {
        return new FileRetrieverManagedConnection(conReqInfo, writer, repository);
    }

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#matchManagedConnections(java.util.Set, javax.security.auth.Subject, javax.resource.spi.ConnectionRequestInfo)
     */
    public ManagedConnection matchManagedConnections(
            Set set, Subject subj, ConnectionRequestInfo conReqInfo)
            throws ResourceException {
        Iterator itr = set.iterator();
        if (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof FileRetrieverManagedConnection) {
                return (FileRetrieverManagedConnection)obj;
            }
        }
        return null;
    }

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#setLogWriter(java.io.PrintWriter)
     */
    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.writer = out;
    }

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#getLogWriter()
     */
    public PrintWriter getLogWriter() throws ResourceException {
        return writer;
    }
    
    /*
     * @see javax.resource.spi.ManagedConnectionFactory#hashCode()
     */
    public int hashCode() {
        if (repository == null) {
            return super.hashCode();
        } else {
            return repository.hashCode(); 
        }
    }

    /*
     * @see javax.resource.spi.ManagedConnectionFactory#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileRetrieverManagedConnectionFactory)) {
            return false;
        }
        if (repository == null) {
            return false;
        }
        return repository.equals(((FileRetrieverManagedConnectionFactory)obj).getRepositoryPath());
    }
    
    /**
     * Returns path to file system repository
     * @return path to file system repository
     */
    public String getRepositoryPath() {
        return repository;
    }

    /**
     * Sets path to file system repository
     * @param path path to file system repository
     */
    public void setRepositoryPath(String path) {
        this.repository = path;
    }
}
