/*****************************************************************
 *   File: FileRetrieverManagedConnectionMetaData.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.04,2005  1.1       Vladimir Shraibman   Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.jca.connector.impl;

import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionMetaData;

/**
 * File Retriever managed connection meta data
 * 
 * @author Vladimir B. Shraibman <shvb@isg.axmor.com>
 */
public class FileRetrieverManagedConnectionMetaData implements
        ManagedConnectionMetaData {

    /** Default instance of the class */
    public final static FileRetrieverManagedConnectionMetaData INSTANCE = 
            new FileRetrieverManagedConnectionMetaData();

    /*
     * @see javax.resource.spi.ManagedConnectionMetaData#getEISProductName()
     */
    public String getEISProductName() throws ResourceException {
        return "File system EIS";
    }

    /*
     * @see javax.resource.spi.ManagedConnectionMetaData#getEISProductVersion()
     */
    public String getEISProductVersion() throws ResourceException {
        return "1.0";
    }

    /*
     * @see javax.resource.spi.ManagedConnectionMetaData#getMaxConnections()
     */
    public int getMaxConnections() throws ResourceException {
        return 0;
    }

    /*
     * @see javax.resource.spi.ManagedConnectionMetaData#getUserName()
     */
    public String getUserName() throws ResourceException {
        return "Unknown";
    }
}
