<%--
  -   File: index.jsp
  -   
  -   Date         Version   Author               Changes
  -   Oct.04,2005  1.1       Vladimir Shraibman   Created
  -
  -   Copyright (c) 2005, IBM Corporation
  -   All rights reserved.
--%>

<%@ page language="java"
    contentType="text/html; charset=utf-8"
    pageEncoding="utf-8"
    import="com.ibm.j2g.jca.connector.*"
%>

<%!
    /* Name of the reference to the File Retriever connector described in the web.xml file */
    private final static String CONNECTOR_REF_NAME = "java:comp/env/ra/FileRetriever";

    /* Returns connection to the File Retriever */
    public FileRetrieverConnection getConnection() throws Exception {
        javax.naming.InitialContext ctx = new javax.naming.InitialContext();
        FileRetrieverConnectionFactory factory = 
                (FileRetrieverConnectionFactory)ctx.lookup(CONNECTOR_REF_NAME);
        return factory.getConnection();
    }
%>

<% 
    // Getting names of directories and files in the repository:
    FileRetrieverConnection connection = null;
    String[] directories;
    String[] files;
    try {
        connection = getConnection();
        directories = connection.listDirectories();
        files = connection.listFiles();
    } finally {
        if (connection != null) {
            connection.close();
        }
    }
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
           "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">     
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>JCA Application</title>
</head>

<body>
    <h3>Contents of the repository</h3>
    <table>
        <tr>
            <td>The following directories and files were found. Click a file to open it:</td>
        </tr>

        <% for(int i = 0; i < directories.length; i++) { %>
        <tr>
            <td>[<%=directories[i]%>]</td>
        </tr>
        <% } %>
        <% for(int i = 0; i < files.length; i++) { %>
        <tr>
            <td><a href="retrieve?file=<%=files[i]%>" target="_new"><%=files[i]%></a></td>
        </tr>
        <% } %>

    </table>
</body>

</html>
