/*****************************************************************
 *   File: BusinessLogicEJB.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.05,2005  1.1       Ivan Dubrov		     Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/

package com.ibm.j2g.security;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

/**
 * Business logic stateless bean.
 * 
 * @ejb.bean name="BusinessLogic" display-name="BusinessLogic bean"
 *           jndi-name="ejb/BusinessLogic" type="Stateless" view-type="remote"
 */
public class BusinessLogicEJB implements SessionBean {

	/** Serial version uid. */
	private static final long serialVersionUID = 4688250533090120601L;

	/**
	 * @ejb.interface-method
	 * @ejb.permission role-name = "uploader"
	 * 
	 * @return result message
	 */
	public String upload() {
		return "File successfully uploaded";
	}

	/**
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext ctx) throws EJBException,
			RemoteException {
		// Nothing...
	}

	/**
	 * Create method.
	 * 
	 * @ejb.create-method
	 * @ejb.permission unchecked="true"
	 * 
	 * @throws EJBException
	 * @throws RemoteException
	 */
	public void ejbCreate() throws EJBException, RemoteException {
		// Nothing...
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() throws EJBException, RemoteException {
		// Nothing...
	}

	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
		// Nothing...

	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
		// Nothing...
	}
}
