/*****************************************************************
 *   File: LogoutServlet.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.05,2005  1.1       Ivan Dubrov		     Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.security;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet that performs logout.
 * 
 * @web.servlet name="Logout" display-name="Logout Servlet"
 * 
 * @web.servlet-mapping url-pattern="/logout"
 * 
 * @author Ivan S. Dubrov <dubrov@isg.axmor.com>
 */
public class LogoutServlet extends HttpServlet {

	/**
	 * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	protected void service(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		req.getSession().invalidate();
		resp.sendRedirect(req.getContextPath() + "/");
		return;
	}
}
