/*****************************************************************
 *   File: UploadServlet.java
 *   
 *   Date         Version   Author               Changes
 *   Oct.05,2005  1.1       Ivan Dubrov		     Created
 *
 *   Copyright (c) 2005, IBM Corporation
 *   All rights reserved.
 *****************************************************************/
package com.ibm.j2g.security;

import java.io.IOException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet that checks if current user owns given role.
 * 
 * @web.servlet name="Upload" display-name="Upload Servlet"
 * 
 * @web.servlet-mapping url-pattern="/upload"
 * 
 * @web.ejb-ref name="ejb/BusinessLogic" type="Session" link="BusinessLogic"
 *              home="com.ibm.j2g.security.BusinessLogicHome"
 *              remote="com.ibm.j2g.security.BusinessLogic"
 * 
 * @author Ivan S. Dubrov <dubrov@isg.axmor.com>
 */
public class UploadServlet extends HttpServlet {

	/** Business logic reference */
	private BusinessLogicHome logicHome;

	/**
	 * @see javax.servlet.Servlet#destroy()
	 */
	public void destroy() {
		logicHome = null;
		super.destroy();
	}

	/**
	 * @see javax.servlet.GenericServlet#init()
	 */
	public void init() throws ServletException {
		super.init();
		try {
			logicHome = BusinessLogicUtil.getHome();
		} catch (Throwable t) {
			throw new ServletException(t);
		}
	}

	/**
	 * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	protected void service(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		BusinessLogic logic = getLogic();
		req.setAttribute("result", logic.upload());
		req.getRequestDispatcher("main.jsp").forward(req, resp);
	}

	/**
	 * Helper for getting business logic bean reference.
	 * 
	 * @return business logic bean reference
	 * @throws ServletException
	 *             wrapper exception
	 */
	protected BusinessLogic getLogic() throws ServletException {
		try {
			return logicHome.create();
		} catch (RemoteException e) {
			throw new ServletException(e);
		} catch (CreateException e) {
			throw new ServletException(e);
		}
	}
}
