/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class ContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private ServletContext context = null;

    public void attributeAdded(ServletContextAttributeEvent event) {
        this.log("attributeAdded('" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this.log("attributeRemoved('" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        this.log("attributeReplaced('" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.log("contextDestroyed()");
        this.context = null;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.context = event.getServletContext();
        this.log("contextInitialized()");
    }

    private void log(String message) {
        if (this.context != null) {
            this.context.log("ContextListener: " + message);
        } else {
            System.out.println("ContextListener: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        if (this.context != null) {
            this.context.log("ContextListener: " + message, throwable);
        } else {
            System.out.println("ContextListener: " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

