/*
 * Decompiled with CFR 0.152.
 */
package compressionFilters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class CompressionResponseStream
extends ServletOutputStream {
    protected int compressionThreshold = 0;
    private int debug = 0;
    protected byte[] buffer = null;
    protected int bufferCount = 0;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected int length = -1;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;

    public CompressionResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
    }

    public void setDebugLevel(int debug) {
        this.debug = debug;
    }

    protected void setBuffer(int threshold) {
        this.compressionThreshold = threshold;
        this.buffer = new byte[this.compressionThreshold];
        if (this.debug > 1) {
            System.out.println("buffer is set to " + this.compressionThreshold);
        }
    }

    public void close() throws IOException {
        if (this.debug > 1) {
            System.out.println("close() @ CompressionResponseStream");
        }
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.gzipstream != null) {
            this.flushToGZip();
            this.gzipstream.close();
            this.gzipstream = null;
        } else if (this.bufferCount > 0) {
            if (this.debug > 2) {
                System.out.print("output.write(");
                System.out.write(this.buffer, 0, this.bufferCount);
                System.out.println(")");
            }
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.debug > 1) {
            System.out.println("flush() @ CompressionResponseStream");
        }
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void flushToGZip() throws IOException {
        if (this.debug > 1) {
            System.out.println("flushToGZip() @ CompressionResponseStream");
        }
        if (this.bufferCount > 0) {
            if (this.debug > 1) {
                System.out.println("flushing out to GZipStream, bufferCount = " + this.bufferCount);
            }
            this.writeToGZip(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.debug > 1) {
            System.out.println("write " + b + " in CompressionResponseStream ");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToGZip();
        }
        this.buffer[this.bufferCount++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.debug > 1) {
            System.out.println("write, bufferCount = " + this.bufferCount + " len = " + len + " off = " + off);
        }
        if (this.debug > 2) {
            System.out.print("write(");
            System.out.write(b, off, len);
            System.out.println(")");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.flushToGZip();
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.writeToGZip(b, off, len);
    }

    public void writeToGZip(byte[] b, int off, int len) throws IOException {
        if (this.debug > 1) {
            System.out.println("writeToGZip, len = " + len);
        }
        if (this.debug > 2) {
            System.out.print("writeToGZip(");
            System.out.write(b, off, len);
            System.out.println(")");
        }
        if (this.gzipstream == null) {
            if (this.debug > 1) {
                System.out.println("new GZIPOutputStream");
            }
            this.response.addHeader("Content-Encoding", "gzip");
            this.gzipstream = new GZIPOutputStream((OutputStream)this.output);
        }
        this.gzipstream.write(b, off, len);
    }

    public boolean closed() {
        return this.closed;
    }
}

