/*
 * Decompiled with CFR 0.152.
 */
package listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public final class SessionListener
implements ServletContextListener,
HttpSessionAttributeListener,
HttpSessionListener {
    private ServletContext context = null;

    public void attributeAdded(HttpSessionBindingEvent event) {
        this.log("attributeAdded('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.log("attributeRemoved('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.log("attributeReplaced('" + event.getSession().getId() + "', '" + event.getName() + "', '" + event.getValue() + "')");
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.log("contextDestroyed()");
        this.context = null;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.context = event.getServletContext();
        this.log("contextInitialized()");
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.log("sessionCreated('" + event.getSession().getId() + "')");
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.log("sessionDestroyed('" + event.getSession().getId() + "')");
    }

    private void log(String message) {
        if (this.context != null) {
            this.context.log("SessionListener: " + message);
        } else {
            System.out.println("SessionListener: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        if (this.context != null) {
            this.context.log("SessionListener: " + message, throwable);
        } else {
            System.out.println("SessionListener: " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

