package org.apache.geronimo.samples.dbtester.beans;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.sql.DataSource;

import org.apache.geronimo.connector.outbound.ConnectionFactorySource;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.InternalKernelException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.NoSuchOperationException;

/**
 * 
 * @author Lasantha Ranaweera
 *
 */

public class DBManagerBean {
	
	private Map poolMap;
	private Map tableMap;
	
	public DBManagerBean(){
		poolMap = new HashMap();
		init();
	}
	
	private void init(){
		Kernel kernel = KernelRegistry.getSingleKernel();
		Set cfList = kernel.listGBeans(new AbstractNameQuery(ConnectionFactorySource.class.getName()));
		
		for(Iterator iterator = cfList.iterator();iterator.hasNext();){

			AbstractName name = (AbstractName)iterator.next();
			try {
				Object rs = kernel.invoke(name, "$getResource", new Object[]{}, new String[]{});
				
				if(rs instanceof javax.sql.DataSource){
					DataSource ds = (DataSource)rs;	
					poolMap.put(name.getArtifact().getArtifactId(), ds);
				}
			} catch (GBeanNotFoundException e) {
				e.printStackTrace();
			} catch (NoSuchOperationException e) {
				e.printStackTrace();
			} catch (InternalKernelException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public Map getDeployedPools(){
		return poolMap;
	}
	
	public Map getTableList(String poolName) throws SQLException {
		
		tableMap = new HashMap();
		
		if(poolMap.containsKey(poolName)){
			DataSource ds = (DataSource)poolMap.get(poolName);
			Connection con = null;
			try {
				
				con = ds.getConnection();
				
				DatabaseMetaData metaData = con.getMetaData();
				String[] tableTypes = {"TABLE"};
				ResultSet rs = metaData.getTables(null, null, null, tableTypes);
				
				while(rs.next()){
					String schemaName = rs.getString("TABLE_SCHEM");
					String tableName = rs.getString("TABLE_NAME"); 
					ArrayList tableList = null;
					
					if(tableMap.containsKey(schemaName)){
						tableList = (ArrayList)tableMap.get(schemaName);
						tableList.add(tableName);
					}else {
						tableList = new ArrayList();
						tableList.add(tableName);
					}
					tableMap.put(schemaName, tableList);
				}
			} catch (SQLException e) {
				throw e;
			}finally {
				if(con != null){
					try {
						con.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}
		}
		
		return tableMap;
	}
	
	public List getTableContents(String poolName, String schemaName, String tableName) throws SQLException {
		
		ArrayList matrix = new ArrayList();
		
		DataSource ds = (DataSource)poolMap.get(poolName);
		Connection con = null;
			
		con = ds.getConnection();
			
		String SQL = "SELECT * FROM ";
		
		if(schemaName == null || schemaName.equals("null")){
			SQL+= tableName; //Problem comes with MySQL 
		}else {
			SQL+= (schemaName+"."+tableName);
		}
			
		PreparedStatement pStmt = con.prepareStatement(SQL);
		ResultSet rs = pStmt.executeQuery();
			
		ResultSetMetaData metaData = rs.getMetaData();
		int columns = metaData.getColumnCount();
			
		ArrayList header = new ArrayList();
		for(int i=1; i<= columns; i++){
			String colName = metaData.getColumnLabel(i);
			header.add(colName);
		}
		matrix.add(header);
			
		while(rs.next()){				
			ArrayList row = new ArrayList();
				
			for(int i=1; i<= columns;i++){
				row.add(rs.getString(i));
			}
				matrix.add(row);
		}
		
		return matrix;
	}
	
}
