package org.apache.geronimo.samples.dbtester.web;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.geronimo.samples.dbtester.beans.DBManagerBean;


public class ContentTableServlet extends HttpServlet {
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		getContent(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request,response);
	}
	
	private void getContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		String poolName = request.getParameter("poolName");
		String schemaName = request.getParameter("schemaName");
		String tableName = request.getParameter("tableName");
		
		
		String path = "/jsp/common_error.jsp";
		
		try {
			DBManagerBean dbManager = (DBManagerBean)request.getSession().getAttribute("dbManager");
			List tableContent = dbManager.getTableContents(poolName, schemaName, tableName);
			
			request.setAttribute("poolName", poolName);
			request.setAttribute("tableName", tableName);
			request.setAttribute("tableContent", tableContent);
			
			path = "/jsp/table_content.jsp";
			
		} catch (SQLException e) {
			e.printStackTrace();
			request.setAttribute("error", e);
		}
		
		request.setAttribute("poolName", poolName);
		getServletContext().getRequestDispatcher(path).forward(request,response);
	}
	
}