package org.apache.geronimo.samples.dbtester.web;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.geronimo.samples.dbtester.beans.DBManagerBean;

public class ListTablesServlet extends HttpServlet{
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		listTables(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request,response);
	}
	
	private void listTables(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		String poolName = request.getParameter("poolname");
		
		String path = "/jsp/common_error.jsp";
		
		try {
			DBManagerBean dbManager = (DBManagerBean)request.getSession().getAttribute("dbManager");
			Map tableMap = dbManager.getTableList(poolName);
			
			request.setAttribute("tableMap", tableMap);
			
			path = "/jsp/table_list.jsp";
			
		} catch (SQLException e) {
			e.printStackTrace();
			request.setAttribute("error", e);
		}
		request.setAttribute("poolName", poolName);
		getServletContext().getRequestDispatcher(path).forward(request,response);
	}
}
