/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.samples.order.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;


import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.geronimo.samples.order.util.PropertyLoader;


public class ConsignmentReciever {
	
	private static final String PROVIDER_URL = "provider.url";
	private static final String QUEUE_NAME = "queue.name";
	
	private static final String CONSIGNMENT_DIR = "consignment.dir";
	
	private static final String PROP_FILE_NAME = "order_mgmt.properties";
	
	private PropertyLoader propLoader;
	
	
	public ConsignmentReciever() {
		propLoader = PropertyLoader.getInstance(PROP_FILE_NAME);
	}
	
	public static void main(String[] args) {
		ConsignmentReciever recv = new ConsignmentReciever();
		recv.recv();
	}

	public void recv() {
		MessageConsumer consumer = null;
		QueueConnection connection = null;
		QueueSession session = null;
		
		try {
			System.out.println("Start Listening Consignment Data ");
			
			ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(propLoader.getValue(PROVIDER_URL));
			connection = (QueueConnection)connectionFactory.createConnection();
			connection.start();
			
			session = connection.createQueueSession(false,Session.AUTO_ACKNOWLEDGE);
			Queue queue = session.createQueue(propLoader.getValue(QUEUE_NAME));
			consumer = session.createConsumer(queue);
			while(true){
				Message message = consumer.receive();
				processMessage(message);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			try {
				if(consumer != null)consumer.close();
				if(session != null)session.close();
				if(connection!= null)connection.close();
			} catch (JMSException e) {
				e.printStackTrace();
			}
		}
	}

	private void processMessage(Message message) {
		try {
			TextMessage request = (TextMessage) message;
			System.out.println("Received a Consignment: \n" + request.getText());
			
			String repoLocation = propLoader.getValue(CONSIGNMENT_DIR);
			
			File repo = new File(repoLocation);
			
			if(!repo.isDirectory() || !repo.exists()){
				System.out.println("Please Set a Repository to Save Order Requests");
			}else {
				saveRequest(repoLocation, request.getText());
			}
		} catch (Exception e) {
			e.printStackTrace();
        }
	}
	
	private void saveRequest(String repo, String request){
		Date timeStamp = new Date();
		
		String fileName = timeStamp.hashCode()+".xml";
		
		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(repo + File.separator + fileName));
			out.write(request);
			out.close();
		} catch (IOException e) {			
			e.printStackTrace();
		}
	}

}
