/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.samples.order.ejb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

import org.apache.geronimo.samples.order.util.PropertyLoader;

/**
 * 
 * 
 * 
 * @ejb.bean name = "OrderRecvMDB"
 *           display-name = "OrderRecvMDB"
 *           description = "Order Recieve Message Driven Bean"
 * 			 destination-type = "javax.jms.Queue"
 *
 */


public class OrderRecvMDB implements MessageDrivenBean, MessageListener{
	

	
	/** The MessageDrivenContext */
	private MessageDrivenContext context;
	
	private static final String ORDER_MGMT_INFO = "order_mgmt.properties";
	private static final String ORDER_REPO = "order.repo";

	/**
	 * An <code>ejbCreate</code> method as required by the EJB specification. <br>
	 * 
	 * The container calls the instances <code>ejbCreate</code> method 
	 * immediately after instantiation.
	 * 
	 * @ejb.create-method
	 */
	public void ejbCreate() {
	}

	/**
	 * The <code>ejbRemove()</code> method as required by the EJB specification.<br>
	 *
	 * A container invokes this method before it ends the life of the 
	 * object. This happens as a result of a client's invoking 
	 * a remove operation, or when a container decides to terminate the 
	 * object after a timeout.   <br>
	 * 
	 * This method is called with no transaction context. 
	 *
	 * @throws EJBException Thrown if the instance could not perform 
	 * the function requested by the container because of an system-level error.
	 */
	public void ejbRemove() throws EJBException {
	}

	/**
	 * Set the associated context. The container calls this method 
	 * after the instance creation.  <br>
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable. <br>
	 * 
	 * This method is called with no transaction context.
	 * 
	 * @param newContext A MessageDrivenContext interface for the instance. 
	 * 
	 * @throws EJBException Thrown by the method to indicate a failure caused by a system-level error.
	 */
	public void setMessageDrivenContext(MessageDrivenContext newContext)
			throws EJBException {
		context = newContext;
	}

	/**
	 * Process a message. <br>
	 * 
	 * @param message The message to process. 
	 */
	public void onMessage(Message message) {
		TextMessage textMessage = (TextMessage) message;
		try {
			
			String request = textMessage.getText();
			System.out.println("Order Recieved \n"+request);
			
			PropertyLoader loader = PropertyLoader.getInstance(ORDER_MGMT_INFO);
			
			String repoLocation = loader.getValue(ORDER_REPO);
			File repo = new File(repoLocation);
			
			if(!repo.isDirectory() || !repo.exists()){
				System.out.println("Please Set a Repository to Save Order Requests");
			}else {
				saveRequest(repoLocation, request);
			}
			
		} catch (JMSException e) {
			e.printStackTrace();
		}
	}
	
	private void saveRequest(String repo, String request){
		Date timeStamp = new Date();
		
		String fileName = timeStamp.hashCode()+".xml";
		
		try {
			BufferedWriter out = new BufferedWriter(new FileWriter(repo + File.separator + fileName));
			out.write(request);
			out.close();
		} catch (IOException e) {			
			e.printStackTrace();
		}
		
	}
	
}
