/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.geronimo.samples.order.web;

import java.io.IOException;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.geronimo.samples.order.util.PropertyLoader;



public class OrderSenderServlet extends HttpServlet{
	
	private static final String CONNECTION_FACTORY_NAME = "jms.connection";
	private static final String QUEUE_NAME = "jms.queue";
	
	private static final String PROP_FILE = "order_mgmt.properties";
	private PropertyLoader propLoader;

	public void init() throws ServletException {
		super.init();		
		propLoader = PropertyLoader.getInstance(PROP_FILE);
	}

	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		manageOrders(req,res);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		doGet(req,res);
	}
	
	private void manageOrders(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException{

		InitialContext context = null;
	    String path = "/jsp/error.jsp";
	    
	    Connection connection = null;
	    MessageProducer producer = null;
	    Session session = null;
	     
		try
	      {
			String customerId = req.getParameter("customerId");
		    String orderId = req.getParameter("orderId");
		    String qty = req.getParameter("quantity");
		    String model = req.getParameter("model");
		    
		    if(!customerId.equals("") && !orderId.equals("") && !qty.equals("")){
		    	
		    	System.out.println("Start Sending Order Request");
		    	
		    	//Creating order request
		    	
		    	String orderRequest = "<Order orderId=\""+orderId+"\" custId=\""+customerId+"\" qty=\""+qty+"\" model=\""+model+"\"/>" ;
			     
				context = new InitialContext();
				 
				ConnectionFactory factory = (ConnectionFactory)context.lookup(propLoader.getValue(CONNECTION_FACTORY_NAME));
				 
				Queue receivingQueue = (Queue)context.lookup(propLoader.getValue(QUEUE_NAME));
				 
				connection = factory.createConnection();
		        session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
		        connection.start();

		        producer = session.createProducer(receivingQueue);
		        TextMessage textMessage = session.createTextMessage();
		        textMessage.setText(orderRequest);
		        producer.send(textMessage);
		        
		        path = "/jsp/index.jsp";
		        
		        System.out.println("Order Request Send");

		    }else{
		    	String error = "";
		    	
		    	if(customerId.equals("")){
		    		error = "Customer Id Cannot be Empty";
		    	}else if(orderId.equals("")){
		    		error = "Order Id Cannot be Empty";
		    	}else if(qty.equals("")){
		    		error = "Quantity Cannot be Empty";
		    	}
		    	req.setAttribute("error",error);
		    }
	      } 

	      catch (Exception e)
	      {
	    	  System.out.println("Error "+e);
	    	  e.printStackTrace();
	      }finally{
	    	  try {
	    		  if(producer != null)producer.close();
				  if(session != null)session.close();
				  if(connection!= null)connection.close();
			} catch (JMSException e) {
				e.printStackTrace();
			}
	   	  }
	      getServletContext().getRequestDispatcher(path).forward(req,res);
	}

}
