/**
 * 
 */
package org.apache.geronimo.samples.inventory.services;

import java.util.List;

import org.apache.geronimo.samples.inventory.Item;
import org.apache.geronimo.samples.inventory.dao.ItemDAO;
import org.apache.geronimo.samples.inventory.exception.DuplicateItemIdException;
import org.apache.geronimo.samples.inventory.exception.NotSufficientQuantityException;


public class InventoryManager {
	
	public List getItems(){
		ItemDAO dao = new ItemDAO();
		return dao.getItems();
	}
	
	public void issueItem(String itemNo, int quantity) throws NotSufficientQuantityException{
		ItemDAO dao = new ItemDAO();
		
		int qoh = dao.getQOH(itemNo);
		
		if(qoh < quantity)throw new NotSufficientQuantityException();
		
		dao.updateQOH(itemNo,(qoh - quantity));
	}
	
	public void recvItem(String itemNo, int quantity){
		ItemDAO dao = new ItemDAO();
		
		int qoh = dao.getQOH(itemNo);
		
		dao.updateQOH(itemNo,(qoh + quantity));		
	}
	
	public void addItem(String itemNo, String itemName, String desc) throws DuplicateItemIdException{
		ItemDAO dao = new ItemDAO();
		
		if(dao.isItemIdExists(itemNo))throw new DuplicateItemIdException();
		Item item = new Item();
		
		item.setItemNo(itemNo);
		item.setItemName(itemName);
		item.setDescription(desc);
		
		dao.addItem(item);
		
	}

}
