/**
 * 
 */
package org.apache.geronimo.samples.inventory.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.geronimo.samples.inventory.exception.DuplicateItemIdException;
import org.apache.geronimo.samples.inventory.services.InventoryManager;


public class AddItemServlet extends HttpServlet {

	
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		process(req,res);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		doGet(req,res);
	}
	
	private void process(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException{
		String itemNo = req.getParameter("item_no");
		String itemName = req.getParameter("item_name");
		String description = req.getParameter("item_desc");
		
		if(!itemNo.equals("") && !itemName.equals("")){
			InventoryManager itemManager = new InventoryManager();
			try {
				itemManager.addItem(itemNo, itemName, description);
				getServletContext().getRequestDispatcher("/welcome.jsp").forward(req,res);
			} catch (DuplicateItemIdException e) {
				req.setAttribute("error","Duplicate Item Id");
				getServletContext().getRequestDispatcher("/jsp/error.jsp").forward(req,res);
			}
		}else{
			String error = "";
			if(itemNo.equals("")){
				error = "Invalid Item Number";
			}else if(itemName.equals("")){
				error = "Invalid Item Name";
			}
			req.setAttribute("error",error);
			getServletContext().getRequestDispatcher("/jsp/error.jsp").forward(req,res);
		}
		
	}
	
	

}
