/**
 * 
 */
package org.apache.geronimo.samples.inventory.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.geronimo.samples.inventory.Item;
import org.apache.geronimo.samples.inventory.util.DBManager;


public class ItemDAO {
	
	public List getItems(){
		ArrayList items = new ArrayList();
		
		Connection con = DBManager.getConnection();
		try {
			
			PreparedStatement pStmt = con.prepareStatement("SELECT i.item_id as item_id, i.item_name as item_name, i.description as description, im.quantity as quantity FROM item i, item_master im WHERE im.item_id = i.item_id");
			ResultSet rs = pStmt.executeQuery();
			int j = 0;
			while(rs.next()){
				ArrayList item = new ArrayList();
				
				String itemId = rs.getString("item_id");
				String itemName = rs.getString("item_name");
				String description = rs.getString("description");
				int quantity = rs.getInt("quantity");
				
				item.add(0, itemId);
				item.add(1, itemName);
				item.add(2, description);
				item.add(3, quantity+"");
				
				items.add(j,item);				
				j++;
				
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}finally{
			if(con != null){
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}		
		
		return items;
	}
	
	public int getQOH(String itemNo){
		
		int qoh = 0;
		Connection con = DBManager.getConnection();
		try {
			
			PreparedStatement pStmt = con.prepareStatement("SELECT quantity FROM item_master WHERE item_id =? ");
			pStmt.setString(1, itemNo);
			
			ResultSet rs = pStmt.executeQuery();
			while(rs.next()){
				qoh = rs.getInt("quantity");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}finally{
			if(con != null){
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}		
		return qoh;
	}
	
	public boolean isItemIdExists(String itemNo){
		boolean isExists = false;
		Connection con = DBManager.getConnection();
		try {
			
			PreparedStatement pStmt = con.prepareStatement("SELECT item_id FROM item WHERE item_id =? ");
			pStmt.setString(1, itemNo);
			
			ResultSet rs = pStmt.executeQuery();
			if(rs.next()){
				isExists = true;
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}finally{
			if(con != null){
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}		
		return isExists;
	}
	
	public void updateQOH(String itemNo, int qoh){
		Connection con = DBManager.getConnection();
		try {
			
			PreparedStatement pStmt = con.prepareStatement("UPDATE item_master SET quantity=? WHERE item_id=?");
			pStmt.setInt(1, qoh);
			pStmt.setString(2, itemNo);
			
			pStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		}finally{
			if(con != null){
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}		
		
	}
	
	public void addItem(Item item) {
		Connection con = DBManager.getConnection();
		try {
			
			PreparedStatement pStmt = con.prepareStatement("INSERT INTO item VALUES(?, ?, ?)");
			pStmt.setString(1, item.getItemNo());
			pStmt.setString(2, item.getItemName());
			pStmt.setString(3, item.getDescription());
			
			pStmt.executeUpdate();
			
			pStmt = con.prepareStatement("INSERT INTO item_master VALUES(?, ?)");
			pStmt.setString(1, item.getItemNo());
			pStmt.setInt(2, 0);
			
			pStmt.executeUpdate();
			
		} catch (SQLException e) {
			e.printStackTrace();
		}finally{
			if(con != null){
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}		
	}

}
