/**
 * 
 */
package org.apache.geronimo.samples.inventory.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.geronimo.samples.inventory.exception.NotSufficientQuantityException;
import org.apache.geronimo.samples.inventory.services.InventoryManager;


public class IssueingServlet extends HttpServlet {

	
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		process(req,res);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		doGet(req,res);
	}
	
	private void process(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException{
		String itemNo = req.getParameter("item_no");
		
		int quantity = 0;
		try {
			quantity = Integer.parseInt(req.getParameter("quantity"));
			InventoryManager itemManager = new InventoryManager();
			itemManager.issueItem(itemNo,quantity);

			getServletContext().getRequestDispatcher("/welcome.jsp").forward(req,res);
		} catch (NumberFormatException e) {
			e.printStackTrace();
			req.setAttribute("error","Invalid Number Format for Quantity");
			getServletContext().getRequestDispatcher("/jsp/error.jsp").forward(req,res);			
		} catch (NotSufficientQuantityException e) {
			req.setAttribute("error","Not Sufficient Qunatity to Issue Items");
			getServletContext().getRequestDispatcher("/jsp/error.jsp").forward(req,res);	
		}
	}
	

}
