package sample.resequencer;

import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;

import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.eip.support.resequence.DefaultComparator;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.jbi.jaxp.StringSource;

/**
 * @author Martin Krasser
 * 
 * @org.apache.xbean.XBean element="dummy-message-sender"
 */
public class DummyMessageSender extends EIPEndpoint {

    private Executor executor;
    
    private ExchangeTarget target;
    
    private String sequenceNumberKey;
    
    public DummyMessageSender() {
        super();
        sequenceNumberKey = DefaultComparator.SEQUENCE_NUMBER_KEY;
    }
    
    public ExchangeTarget getTarget() {
        return target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }
    
    public String getSequenceNumberKey() {
        return sequenceNumberKey;
    }

    public void setSequenceNumberKey(String sequenceNumberKey) {
        this.sequenceNumberKey = sequenceNumberKey;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (executor == null) {
            executor = getServiceUnit().getComponent().getExecutor();
        }
        executor.execute(new DummyMessageGenerator());
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    @Override
    protected void processAsync(MessageExchange arg0) throws Exception {
        // ignore
    }

    @Override
    protected void processSync(MessageExchange arg0) throws Exception {
        // ignore
    }

    private void sendExchange(long number) {
        try {
            send(createExchange(number));
            logger.info("sent number " + number);
        } catch (MessagingException e) {
        }
    }
    
    private MessageExchange createExchange(long number) throws MessagingException {
        InOnly me = getExchangeFactory().createInOnlyExchange();
        NormalizedMessage m = me.createMessage();
        m.setContent(new StringSource("<number>" + number + "</number>"));
        m.setProperty(sequenceNumberKey, new Long(number));
        me.setInMessage(m);
        target.configureTarget(me, getContext());
        return me;
    }
    
    private class DummyMessageGenerator implements Runnable {

        public void run() {
            logger.info("countdown: ");
            for (int i = 5; i > 0; i--) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    logger.error(e);
                }
                logger.info(i + " sec");
            }
            sendExchange(5);
            sendExchange(6);
            sendExchange(10);
            sendExchange(2);
            sendExchange(3);
            sendExchange(1);
            sendExchange(8);
            sendExchange(4);
            sendExchange(9);
            sendExchange(7);
        }
        
    }
}
