/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.util;

import com.mockobjects.util.ErrorLogger;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestSuite;

public class SuiteBuilder {
    public static TestSuite buildTest(Class allTestsClass) {
        return SuiteBuilder.buildTest(allTestsClass, new ErrorLogger());
    }

    public static TestSuite buildTest(Class allTestsClass, ErrorLogger logger) {
        TestSuite result = new TestSuite();
        Method[] methods = allTestsClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String name = m.getName();
            if (SuiteBuilder.isAddMethod(m)) {
                try {
                    Object[] args = new Object[]{result};
                    m.invoke((Object)allTestsClass, args);
                }
                catch (Exception ex) {
                    logger.error("Error creating Test from " + name, ex);
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean isAddMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 1 && name.startsWith("add") && returnType.equals(Void.TYPE) && Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers());
    }
}

