/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.codehaus.activemq.journal.impl.BatchedWrite;
import org.codehaus.activemq.journal.impl.Mark;
import org.codehaus.activemq.journal.impl.RecordFooter;
import org.codehaus.activemq.journal.impl.RecordHeader;
import org.codehaus.activemq.journal.impl.RecordLocationImpl;

public class Segment {
    public static final int SEGMENT_HEADER_SIZE = 256;
    private File file;
    private final int initialSize;
    private final byte index;
    private int id;
    private long firstSequenceId;
    private long lastSequenceId;
    private boolean active = false;
    private final Mark lastMark = new Mark();
    private int appendOffset = 0;
    private RandomAccessFile randomAccessFile;
    private boolean readOnly;
    private FileChannel fileChannel;

    public Segment(File file, int initialSize, byte index) throws IOException {
        this.file = file;
        this.initialSize = initialSize;
        this.index = index;
        boolean initializationNeeeded = !file.exists();
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.randomAccessFile.seek(0L);
        this.fileChannel = this.randomAccessFile.getChannel();
        if (initializationNeeeded) {
            this.reinitialize();
        }
        this.loadState();
    }

    public void seek(int newPos) throws IOException {
        this.randomAccessFile.seek(newPos);
    }

    private void loadState() throws IOException {
        this.seek(0);
        try {
            this.read(this.randomAccessFile);
            int firstCode = this.hashCode();
            this.read(this.randomAccessFile);
            if (firstCode == this.hashCode() && (this.readOnly || !this.active)) {
                return;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.firstSequenceId = -1L;
        this.lastSequenceId = -1L;
        this.readOnly = false;
        this.active = true;
        int offset = 256;
        long fileSize = this.randomAccessFile.length();
        RecordHeader header = new RecordHeader();
        RecordFooter footer = new RecordFooter();
        while ((long)(offset + 35) < fileSize) {
            this.seek(offset);
            try {
                header.readRecordHeader(this.randomAccessFile);
            }
            catch (IOException e) {
                break;
            }
            if (!header.isValid()) break;
            if (this.firstSequenceId == -1L) {
                this.firstSequenceId = header.sequenceId;
            } else if (this.lastSequenceId >= header.sequenceId) break;
            if ((long)(offset + header.length + 35) > fileSize) break;
            byte[] data = null;
            if (RecordFooter.isChecksumingEnabled() || header.recordType == 2) {
                data = new byte[header.length];
                this.randomAccessFile.readFully(data);
            }
            this.seek(offset + header.length + 16);
            try {
                footer.readRecordFooter(this.randomAccessFile);
            }
            catch (IOException e) {
                break;
            }
            if (!footer.matches(header) || RecordFooter.isChecksumingEnabled() && !footer.matches(data)) break;
            if (header.recordType == 2) {
                this.lastMark.readExternal(data);
            }
            this.lastSequenceId = header.sequenceId;
            this.appendOffset = offset += header.length + 35;
        }
        this.storeState();
    }

    private void resize() throws IOException {
        this.randomAccessFile.setLength(this.initialSize);
    }

    private void storeState() throws IOException {
        int restorePos = this.getSeekPos();
        this.seek(0);
        this.writeHeader(this.randomAccessFile);
        this.writeHeader(this.randomAccessFile);
        this.force();
        this.seek(restorePos);
    }

    private int getSeekPos() throws IOException {
        return (int)this.randomAccessFile.getFilePointer();
    }

    public void force() throws IOException {
        this.fileChannel.force(false);
    }

    public void reinitialize() throws IOException {
        this.readOnly = true;
        this.active = false;
        this.firstSequenceId = -1L;
        this.appendOffset = -1;
        this.id = -1;
        this.lastSequenceId = -1L;
        this.lastMark.offsetId = -1;
        this.lastMark.sequenceId = -1L;
        this.appendOffset = 256;
        this.resize();
        this.storeState();
    }

    public void setReadOnly(boolean enable) throws IOException {
        if (!this.active) {
            throw new IllegalStateException("Not Active.");
        }
        this.readOnly = enable;
        this.storeState();
    }

    public void activate(int id) throws IOException {
        if (this.active) {
            throw new IllegalStateException("Allready Active.");
        }
        this.id = id;
        this.readOnly = false;
        this.active = true;
        this.appendOffset = 256;
        this.firstSequenceId = -1L;
        this.lastSequenceId = -1L;
        this.storeState();
        this.seek(this.appendOffset);
    }

    public int hashCode() {
        int rc = this.id;
        rc ^= this.appendOffset;
        rc ^= (int)(0xFFFFFFFFFFFFFFFFL & this.firstSequenceId);
        rc ^= (int)(0xFFFFFFFFFFFFFFFFL & this.firstSequenceId >> 4);
        rc ^= (int)(0xFFFFFFFFFFFFFFFFL & this.lastSequenceId);
        rc ^= (int)(0xFFFFFFFFFFFFFFFFL & this.lastSequenceId >> 4);
        if (this.active) {
            rc ^= 0xABD01212;
        }
        if (this.readOnly) {
            rc ^= 0x1F8ADC21;
        }
        return rc;
    }

    private void writeHeader(DataOutput f) throws IOException {
        f.writeInt(this.id);
        f.writeLong(this.firstSequenceId);
        f.writeLong(this.lastSequenceId);
        f.writeBoolean(this.active);
        f.writeBoolean(this.readOnly);
        f.writeLong(this.lastMark.sequenceId);
        f.writeInt(this.lastMark.offsetId);
        f.writeInt(this.appendOffset);
        f.writeInt(this.hashCode());
    }

    private void read(DataInput f) throws IOException {
        this.id = f.readInt();
        this.firstSequenceId = f.readLong();
        this.lastSequenceId = f.readLong();
        this.active = f.readBoolean();
        this.readOnly = f.readBoolean();
        this.lastMark.sequenceId = f.readLong();
        this.lastMark.offsetId = f.readInt();
        this.appendOffset = f.readInt();
        if (f.readInt() != this.hashCode()) {
            throw new IOException();
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getFirstSequenceId() {
        return this.firstSequenceId;
    }

    public Mark getLastMark() {
        return this.lastMark;
    }

    public long getLastSequenceId() {
        return this.lastSequenceId;
    }

    public int getAppendOffset() {
        return this.appendOffset;
    }

    public boolean isAtAppendOffset() throws IOException {
        return this.appendOffset == this.getSeekPos();
    }

    public void write(BatchedWrite write) throws IOException {
        ByteBuffer byteBuffer = write.getByteBuffer();
        byteBuffer.flip();
        this.write(byteBuffer);
        if (this.firstSequenceId == -1L) {
            this.firstSequenceId = write.getFirstSequenceId();
        }
        this.lastSequenceId = write.getLastSequenceId();
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (!this.active) {
            throw new IllegalStateException("Segment is not active.  Writes are not allowed");
        }
        if (this.readOnly) {
            throw new IllegalStateException("Segment has been marked Read Only.  Writes are not allowed");
        }
        if (!this.isAtAppendOffset()) {
            throw new IllegalStateException("Segment not at append location.");
        }
        int writeLength = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0) {
            this.fileChannel.write(byteBuffer);
        }
        this.appendOffset += writeLength;
    }

    public void readRecordHeader(RecordHeader seekedRecordHeader) throws IOException {
        seekedRecordHeader.readRecordHeader(this.randomAccessFile);
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    public void read(byte[] answer) throws IOException {
        this.randomAccessFile.readFully(answer);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public byte getIndex() {
        return this.index;
    }

    public String toString() {
        return "Segment:" + this.index + ":" + this.id;
    }

    public RecordLocationImpl getFirstRecordLocation(byte fm) {
        return new RecordLocationImpl(fm, this.index, 256, this.firstSequenceId);
    }
}

