/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.cache;

import java.io.IOException;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.service.impl.PersistenceAdapterSupport;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.cache.CacheMessageStore;
import org.codehaus.activemq.store.cache.CacheTopicMessageStore;
import org.codehaus.activemq.store.cache.MessageCache;
import org.codehaus.activemq.store.cache.SimpleMessageCache;

public abstract class CachePersistenceAdapter
extends PersistenceAdapterSupport {
    private static final Log log = LogFactory.getLog((Class)CachePersistenceAdapter.class);
    private PersistenceAdapter longTermPersistence;

    public CachePersistenceAdapter() {
    }

    public CachePersistenceAdapter(PersistenceAdapter longTermPersistence) throws IOException {
        this.longTermPersistence = longTermPersistence;
    }

    public Map getInitialDestinations() {
        return this.longTermPersistence.getInitialDestinations();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        MessageStore longtermStore = this.longTermPersistence.createQueueMessageStore(destinationName);
        CacheMessageStore store = new CacheMessageStore(this, longtermStore, this.createMessageCache(destinationName));
        return store;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        TopicMessageStore longtermStore = this.longTermPersistence.createTopicMessageStore(destinationName);
        CacheTopicMessageStore store = new CacheTopicMessageStore(this, longtermStore, (MessageCache)new SimpleMessageCache());
        return store;
    }

    public PreparedTransactionStore createPreparedTransactionStore() throws JMSException {
        return this.longTermPersistence.createPreparedTransactionStore();
    }

    public void beginTransaction() throws JMSException {
        this.longTermPersistence.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.longTermPersistence.commitTransaction();
    }

    public void rollbackTransaction() {
        this.longTermPersistence.rollbackTransaction();
    }

    public void start() throws JMSException {
        this.longTermPersistence.start();
    }

    public void stop() throws JMSException {
        this.longTermPersistence.stop();
    }

    public PersistenceAdapter getLongTermPersistence() {
        return this.longTermPersistence;
    }

    public void setLongTermPersistence(PersistenceAdapter longTermPersistence) {
        this.longTermPersistence = longTermPersistence;
    }

    protected abstract MessageCache createMessageCache(String var1);
}

