/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.lib.ArrayUtil;

class TableFilter {
    static final int CONDITION_NONE = -1;
    static final int CONDITION_UNORDERED = 0;
    static final int CONDITION_START_END = 1;
    static final int CONDITION_START = 2;
    static final int CONDITION_END = 3;
    static final int CONDITION_OUTER = 4;
    Table filterTable;
    private String tableAlias;
    private Index filterIndex;
    private Node currentNode;
    private Object[] emptyData;
    private Expression eStart;
    private Expression eEnd;
    Expression eAnd;
    boolean isOuterJoin;
    boolean isAssigned;
    boolean isMultiFindFirst;
    Expression[] findFirstExpressions;
    Object[] currentData;
    Row currentRow;
    boolean nonJoinIsNull;
    boolean isCurrentOuter;

    TableFilter(Table table, String string, boolean bl) {
        this.filterTable = table;
        this.tableAlias = string == null ? table.getName().name : string;
        this.isOuterJoin = bl;
        this.emptyData = this.filterTable.getNewRow();
    }

    String getName() {
        return this.tableAlias;
    }

    Table getTable() {
        return this.filterTable;
    }

    static final int toConditionType(int n) {
        switch (n) {
            case 26: 
            case 27: 
            case 30: {
                return 0;
            }
            case 21: 
            case 32: {
                return 1;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 24: 
            case 25: {
                return 3;
            }
        }
        return -1;
    }

    void setConditions(Expression expression) throws HsqlException {
        this.setCondition(expression);
        if (this.filterIndex == null) {
            this.filterIndex = this.filterTable.getPrimaryIndex();
        }
        if (this.filterIndex.getVisibleColumns() == 1 || this.eStart == null || this.eAnd == null || this.eStart.exprType != 21) {
            return;
        }
        boolean[] blArray = this.filterTable.getNewColumnCheckList();
        Expression[] expressionArray = new Expression[blArray.length];
        int n = this.eStart.getArg().getColumnNr();
        blArray[n] = true;
        expressionArray[n] = this.eStart.getArg2();
        this.eAnd.getEquiJoinColumns(this, blArray, expressionArray);
        if (ArrayUtil.containsAllTrueElements(blArray, this.filterIndex.colCheck)) {
            this.isMultiFindFirst = true;
            this.findFirstExpressions = expressionArray;
        }
    }

    private void setCondition(Expression expression) throws HsqlException {
        int n = expression.getType();
        Expression expression2 = expression.getArg();
        Expression expression3 = expression.getArg2();
        this.isAssigned = true;
        if (n == 28) {
            this.setCondition(expression2);
            this.setCondition(expression3);
            return;
        }
        int n2 = TableFilter.toConditionType(n);
        if (n2 == -1) {
            return;
        }
        if (expression2.getFilter() == this && expression3.getFilter() == this) {
            n2 = 0;
        } else if (expression2.getFilter() == this) {
            if (!expression.isInJoin && this.isOuterJoin) {
                return;
            }
        } else {
            if (expression3.getFilter() == this && n2 != 0) {
                expression.swapCondition();
                this.setCondition(expression);
                return;
            }
            if (expression2.outerFilter == this) {
                n2 = 4;
            } else {
                return;
            }
        }
        if (!expression3.isResolved()) {
            return;
        }
        if (expression2.outerFilter != null && expression2.outerFilter != this) {
            return;
        }
        if (n2 == 0) {
            if (!this.isOuterJoin) {
                this.addAndCondition(expression);
            }
            return;
        }
        if (n2 == 4) {
            this.addAndCondition(expression);
            expression.setTrue();
            return;
        }
        int n3 = expression2.getColumnNr();
        Index index = this.filterTable.getIndexForColumn(n3);
        if (index == null || this.filterIndex != index && this.filterIndex != null) {
            this.addAndCondition(expression);
            return;
        }
        this.filterIndex = index;
        switch (n2) {
            case 1: {
                if (this.eStart != null || this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = this.eStart = new Expression(expression);
                break;
            }
            case 2: {
                if (this.eStart != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eStart = new Expression(expression);
                break;
            }
            case 3: {
                if (this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = new Expression(expression);
            }
        }
        expression.setTrue();
    }

    boolean findFirst() throws HsqlException {
        Object object;
        this.nonJoinIsNull = false;
        this.isCurrentOuter = false;
        if (this.filterIndex == null) {
            this.filterIndex = this.filterTable.getPrimaryIndex();
        }
        if (this.isMultiFindFirst) {
            Object[] objectArray = this.filterTable.getNewRow();
            object = this.filterTable.getColumnTypes();
            for (int i = 0; i < this.findFirstExpressions.length; ++i) {
                Expression expression = this.findFirstExpressions[i];
                if (expression == null) continue;
                objectArray[i] = expression.getValue(null, object[i]);
            }
            this.currentNode = this.filterIndex.findFirst(objectArray);
        } else if (this.eStart == null) {
            this.currentNode = this.eEnd == null ? this.filterIndex.first() : this.filterIndex.findFirstNotNull();
        } else {
            int n = this.eStart.getArg().getDataType();
            object = this.eStart.getArg2().getValue(null, n);
            this.currentNode = this.filterIndex.findFirst(object, this.eStart.getType());
        }
        while (this.currentNode != null) {
            this.currentData = this.currentNode.getData();
            this.currentRow = this.currentNode.getRow();
            if (this.eEnd != null && !this.eEnd.testCondition(null)) break;
            if (this.eAnd == null || this.eAnd.testCondition(null)) {
                return true;
            }
            this.currentNode = this.filterIndex.next(this.currentNode);
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    boolean next() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = false;
        this.currentNode = this.filterIndex.next(this.currentNode);
        while (this.currentNode != null) {
            this.currentData = this.currentNode.getData();
            this.currentRow = this.currentNode.getRow();
            if (this.eEnd != null && !this.eEnd.testCondition(null)) break;
            if (this.eAnd == null || this.eAnd.testCondition(null)) {
                return true;
            }
            this.currentNode = this.filterIndex.next(this.currentNode);
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    boolean nextOuter() throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = true;
        this.currentData = this.emptyData;
        this.currentRow = null;
        return this.eAnd == null || this.eAnd.getFilter() != this && this.eAnd.isInJoin || this.eAnd.testCondition(null);
    }

    private void addAndCondition(Expression expression) {
        Expression expression2;
        Expression expression3 = new Expression(expression);
        this.eAnd = this.eAnd == null ? expression3 : (expression2 = new Expression(28, this.eAnd, expression3));
        expression.setTrue();
    }

    void setAsCheckFilter() {
        this.filterIndex = null;
    }

    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Index index = this.filterIndex;
        Index index2 = this.filterTable.getPrimaryIndex();
        int[] nArray = this.filterTable.getPrimaryKey();
        boolean bl2 = false;
        boolean bl3 = bl = this.eStart == null && this.eEnd == null;
        if (index == null) {
            index = index2;
        }
        if (index == index2 && nArray == null) {
            bl2 = true;
            bl = true;
        }
        stringBuffer.append(super.toString()).append('\n');
        stringBuffer.append("table=[").append(this.filterTable.getName().name).append("]\n");
        stringBuffer.append("alias=[").append(this.tableAlias).append("]\n");
        stringBuffer.append("access=[").append(bl ? "FULL SCAN" : "INDEX PRED").append("]\n");
        stringBuffer.append("index=[");
        stringBuffer.append(index == null ? "NONE" : (index.getName() == null ? "UNNAMED" : index.getName().name));
        stringBuffer.append(bl2 ? "[HIDDEN]]\n" : "]\n");
        stringBuffer.append("isOuterJoin=[").append(this.isOuterJoin).append("]\n");
        stringBuffer.append("eStart=[").append(this.eStart).append("]\n");
        stringBuffer.append("eEnd=[").append(this.eEnd).append("]\n");
        stringBuffer.append("eAnd=[").append(this.eAnd).append("]");
        return stringBuffer.toString();
    }
}

