/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;

public class PostgreSQLDialect
extends Dialect {
    public PostgreSQLDialect() {
        this.registerColumnType(-7, "bool");
        this.registerColumnType(-5, "int8");
        this.registerColumnType(5, "int2");
        this.registerColumnType(-6, "int2");
        this.registerColumnType(4, "int4");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float4");
        this.registerColumnType(8, "float8");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "bytea");
        this.registerColumnType(2005, "text");
        this.registerColumnType(2004, "bytea");
        this.registerColumnType(2, "numeric");
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cbrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("random", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("trunc", new StandardSQLFunction());
        this.registerFunction("ceil", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("chr", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("initcap", new StandardSQLFunction());
        this.registerFunction("to_ascii", new StandardSQLFunction());
        this.registerFunction("quote_ident", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("quote_literal", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("md5", new StandardSQLFunction());
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("char_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("octet_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("current_date", new NoArgSQLFunction(Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction(Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP, false));
        this.registerFunction("localtime", new NoArgSQLFunction(Hibernate.TIME, false));
        this.registerFunction("localtimestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP, false));
        this.registerFunction("now", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("timeofday", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("age", new StandardSQLFunction());
        this.registerFunction("current_user", new NoArgSQLFunction(Hibernate.STRING, false));
        this.registerFunction("session_user", new NoArgSQLFunction(Hibernate.STRING, false));
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING, false));
        this.registerFunction("current_database", new NoArgSQLFunction(Hibernate.STRING, true));
        this.registerFunction("current_schema", new NoArgSQLFunction(Hibernate.STRING, true));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval ('" + sequenceName + "')";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return true;
    }
}

