/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.axis;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.axis.components.jms.BeanVendorAdapter;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.codehaus.activemq.ActiveMQConnectionFactory;

public class ActiveMQVendorAdapter
extends BeanVendorAdapter {
    protected static final String QCF_CLASS;
    protected static final String TCF_CLASS;
    public static final String BROKER_URL = "brokerURL";
    public static final String DEFAULT_USERNAME = "defaultUser";
    public static final String DEFAULT_PASSWORD = "defaultPassword";
    public static final String EMBEDDED_BROKER = "embeddedBroker";

    public QueueConnectionFactory getQueueConnectionFactory(HashMap properties) throws Exception {
        properties = (HashMap)properties.clone();
        properties.put("transport.jms.ConnectionFactoryClass", QCF_CLASS);
        return super.getQueueConnectionFactory(properties);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap properties) throws Exception {
        properties = (HashMap)properties.clone();
        properties.put("transport.jms.ConnectionFactoryClass", TCF_CLASS);
        return super.getTopicConnectionFactory(properties);
    }

    public void addVendorConnectionFactoryProperties(JMSURLHelper jmsUrl, HashMap properties) {
        if (jmsUrl.getPropertyValue(BROKER_URL) != null) {
            properties.put(BROKER_URL, jmsUrl.getPropertyValue(BROKER_URL));
        }
        if (jmsUrl.getPropertyValue(DEFAULT_USERNAME) != null) {
            properties.put(DEFAULT_USERNAME, jmsUrl.getPropertyValue(DEFAULT_USERNAME));
        }
        if (jmsUrl.getPropertyValue(DEFAULT_PASSWORD) != null) {
            properties.put(DEFAULT_PASSWORD, jmsUrl.getPropertyValue(DEFAULT_PASSWORD));
        }
        if (jmsUrl.getPropertyValue(EMBEDDED_BROKER) != null) {
            properties.put(EMBEDDED_BROKER, jmsUrl.getPropertyValue(EMBEDDED_BROKER));
        }
    }

    public boolean isMatchingConnectionFactory(ConnectionFactory connectionFactory, JMSURLHelper jmsURL, HashMap properties) {
        String propertyBrokerURL;
        String brokerURL = null;
        boolean embeddedBroker = false;
        if (connectionFactory instanceof ActiveMQConnectionFactory) {
            ActiveMQConnectionFactory amqConnectionFactory = (ActiveMQConnectionFactory)connectionFactory;
            brokerURL = amqConnectionFactory.getBrokerURL();
            embeddedBroker = amqConnectionFactory.isUseEmbeddedBroker();
        }
        if (!brokerURL.equals(propertyBrokerURL = (String)properties.get(BROKER_URL))) {
            return false;
        }
        String tmpEmbeddedBroker = (String)properties.get(EMBEDDED_BROKER);
        boolean propertyEmbeddedBroker = false;
        if (tmpEmbeddedBroker != null) {
            propertyEmbeddedBroker = Boolean.valueOf(tmpEmbeddedBroker);
        }
        return embeddedBroker == propertyEmbeddedBroker;
    }

    static {
        TCF_CLASS = QCF_CLASS = ActiveMQConnectionFactory.class.getName();
    }
}

