/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.codehaus.activemq.journal.InvalidRecordLocationException;
import org.codehaus.activemq.journal.Journal;
import org.codehaus.activemq.journal.JournalEventListener;
import org.codehaus.activemq.journal.RecordLocation;
import org.codehaus.activemq.journal.impl.LogFile;
import org.codehaus.activemq.journal.impl.LogFileManager;
import org.codehaus.activemq.journal.impl.RecordLocationImpl;
import org.codehaus.activemq.util.LongSequenceGenerator;

public class JournalImpl
implements Journal {
    LogFileManager manager;
    LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();

    public JournalImpl() throws IOException {
        this(new File("logs"));
    }

    public JournalImpl(File logDirectory) throws IOException {
        this.manager = new LogFileManager(0, this.sequenceGenerator, new LogFile(logDirectory));
        this.initSequenceId();
    }

    public JournalImpl(File logDirectory, int segments, int segmentSize) throws IOException {
        this.manager = new LogFileManager(0, this.sequenceGenerator, new LogFile(logDirectory, segments, segmentSize));
        this.initSequenceId();
    }

    private void initSequenceId() {
        long id = this.manager.getLastSequenceId();
        if (id == -1L) {
            id = 0L;
        }
        this.sequenceGenerator.setLastSequenceId(id);
    }

    public RecordLocation write(byte[] data, boolean sync) throws IOException {
        return this.manager.write(data, sync);
    }

    public void setMark(RecordLocation recordLocator, boolean force) throws InvalidRecordLocationException, IOException {
        RecordLocationImpl rl = (RecordLocationImpl)recordLocator;
        try {
            this.manager.setMark(rl, force);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public RecordLocation getMark() {
        return this.manager.getMark();
    }

    public void close() throws IOException {
        this.manager.close();
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.manager.setJournalEventListener(eventListener);
    }

    public RecordLocation getNextRecordLocation(RecordLocation lastLocation) throws IOException, InvalidRecordLocationException {
        RecordLocationImpl rl = (RecordLocationImpl)lastLocation;
        return this.manager.getNextRecordLocation(rl);
    }

    public byte[] read(RecordLocation location) throws InvalidRecordLocationException, IOException {
        RecordLocationImpl rl = (RecordLocationImpl)location;
        return this.manager.read(rl);
    }

    public String toString() {
        return "JournalImpl at '" + this.manager.getLogDirectory() + "' using " + this.manager.getTotalSegements() + " x " + (float)this.manager.getInitialSegmentSize() / 1048576.0f + " Meg log files.";
    }
}

