/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.gnet;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.net.URI;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.AcceptableProtocol;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolFactory;
import org.apache.geronimo.network.protocol.ServerSocketAcceptor;
import org.apache.geronimo.network.protocol.ServerSocketAcceptorListener;
import org.apache.geronimo.network.protocol.SocketProtocol;
import org.apache.geronimo.pool.ClockPool;
import org.apache.geronimo.pool.ThreadPool;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportServerChannel;
import org.codehaus.activemq.transport.TransportServerChannelSupport;
import org.codehaus.activemq.transport.gnet.GTransportChannel;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class GTransportServerChannel
extends TransportServerChannelSupport
implements TransportServerChannel {
    protected static final int BACKLOG = 500;
    private static final Log log = LogFactory.getLog((Class)GTransportServerChannel.class);
    private WireFormat wireFormat;
    private SynchronizedBoolean closed;
    private ThreadPool tp;
    private ClockPool cp;
    private SelectorManager sm;
    private ServerSocketAcceptor ssa;
    private ProtocolFactory pf;
    private Latch startLatch;

    public GTransportServerChannel(WireFormat wireFormat, URI bindAddr, SelectorManager selectorManager, ThreadPool threadPool, ClockPool clockPool) throws Exception {
        super(bindAddr);
        this.wireFormat = wireFormat;
        this.sm = selectorManager;
        this.tp = threadPool;
        this.cp = clockPool;
        this.closed = new SynchronizedBoolean(false);
        this.startLatch = new Latch();
        SocketProtocol spt = new SocketProtocol();
        spt.setTimeout(30000L);
        spt.setSelectorManager(this.sm);
        this.pf = new ProtocolFactory();
        this.pf.setClockPool(this.cp);
        this.pf.setMaxAge(Long.MAX_VALUE);
        this.pf.setMaxInactivity(Long.MAX_VALUE);
        this.pf.setReclaimPeriod(10000L);
        this.pf.setTemplate((AcceptableProtocol)spt);
        this.pf.setAcceptedCallBack(this.createAcceptedCallBack());
        this.ssa = new ServerSocketAcceptor();
        this.ssa.setSelectorManager(this.sm);
        this.ssa.setTimeOut(5000);
        this.ssa.setUri(bindAddr);
        this.ssa.setAcceptorListener((ServerSocketAcceptorListener)this.pf);
    }

    private ProtocolFactory.AcceptedCallBack createAcceptedCallBack() {
        return new ProtocolFactory.AcceptedCallBack(){

            public void accepted(AcceptableProtocol p) {
                try {
                    GTransportServerChannel.this.startLatch.acquire();
                    if (p != null) {
                        GTransportChannel channel = new GTransportChannel(GTransportServerChannel.this.wireFormat, (Protocol)p, GTransportServerChannel.this.tp);
                        GTransportServerChannel.this.addClient(channel);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Caught while attempting to add new protocol: " + e), (Throwable)e);
                }
            }
        };
    }

    public void start() throws JMSException {
        super.start();
        try {
            this.ssa.startup();
        }
        catch (Exception e) {
            JMSException jmsEx = new JMSException("Could not start ServerSocketAcceptor: " + e);
            jmsEx.setLinkedException(e);
            throw jmsEx;
        }
        this.startLatch.release();
    }

    public void stop() throws JMSException {
        if (this.closed.commit(false, true)) {
            super.stop();
            try {
                this.ssa.drain();
                this.pf.drain();
            }
            catch (Throwable e) {
                throw JMSExceptionHelper.newJMSException("Failed to stop: " + e, e);
            }
        }
    }

    public String toString() {
        return "GTransportServerChannel@" + this.getUrl();
    }
}

