/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.spring.interceptor;

import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.spring.SpringObjectFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ActionAutowiringInterceptor
extends AroundInterceptor
implements ApplicationContextAware {
    private ApplicationContext context;
    private boolean contextLoaded = false;

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        ApplicationContext context = this.getApplicationContext();
        if (context == null) {
            return;
        }
        Action bean = invocation.getAction();
        SpringObjectFactory tempFactory = new SpringObjectFactory();
        tempFactory.setApplicationContext(context);
        tempFactory.autoWireBean(bean);
    }

    protected ApplicationContext getApplicationContext() {
        if (!this.contextLoaded) {
            ServletConfig config = (ServletConfig)ActionContext.getContext().get((Object)"com.opensymphony.xwork.dispatcher.ServletConfig");
            ServletContext sContext = config.getServletContext();
            try {
                this.setApplicationContext((ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sContext));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.context;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
        this.contextLoaded = true;
    }
}

