/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    static final int ACQ_RETRY_ATTEMPTS = 30;
    ResourcePool rp;
    ConnectionEventListener cl = new ConnectionEventListenerImpl();
    ConnectionTester connectionTester;
    GooGooStatementCache scache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource cpds, final DbAuth auth, int min, int max, int inc, int idleConnectionTestPeriod, int maxIdleTime, final boolean testConnectionOnCheckout, GooGooStatementCache myscache, final ConnectionTester connectionTester, ResourcePoolFactory fact) throws SQLException {
        try {
            this.scache = myscache;
            this.connectionTester = connectionTester;
            ResourcePool.Manager manager = new ResourcePool.Manager(){

                public Object acquireResource() throws Exception {
                    PooledConnection out;
                    PooledConnection pooledConnection = out = auth.equals(C3P0ImplUtils.NULL_AUTH) ? cpds.getPooledConnection() : cpds.getPooledConnection(auth.getUser(), auth.getPassword());
                    if (C3P0PooledConnectionPool.this.scache != null) {
                        if (out instanceof C3P0PooledConnection) {
                            ((C3P0PooledConnection)out).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else {
                            System.err.print("Warning! StatementPooling not ");
                            System.err.print("implemented for external (non-c3p0) ");
                            System.err.println("ConnectionPoolDataSources.");
                        }
                    }
                    out.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    return out;
                }

                public void refurbishResourceOnCheckout(Object resc) throws Exception {
                    if (testConnectionOnCheckout) {
                        this.refurbishResource(resc);
                    }
                }

                public void refurbishResourceOnCheckin(Object resc) throws Exception {
                }

                public void refurbishIdleResource(Object resc) throws Exception {
                    this.refurbishResource(resc);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                private void refurbishResource(Object resc) throws Exception {
                    void var3_4;
                    int status;
                    PooledConnection pc = (PooledConnection)resc;
                    Connection conn = null;
                    try {
                        pc.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        conn = pc.getConnection();
                        status = connectionTester.activeCheckConnection(conn);
                    }
                    catch (SQLException e) {
                        try {
                            e.printStackTrace();
                            status = -1;
                        }
                        catch (Throwable throwable) {
                            ConnectionUtils.attemptClose(conn);
                            pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                            throw throwable;
                        }
                        ConnectionUtils.attemptClose(conn);
                        pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    }
                    ConnectionUtils.attemptClose(conn);
                    pc.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    switch (var3_4) {
                        case 0: {
                            break;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            throw new SQLException("Connection is invalid");
                        }
                        default: {
                            throw new Error("Bad Connection Tester (" + connectionTester + ") " + "returned invalid status (" + (int)var3_4 + ").");
                        }
                    }
                }

                public void destroyResource(Object resc) throws Exception {
                    ((PooledConnection)resc).close();
                }
            };
            ResourcePoolFactory resourcePoolFactory = fact;
            synchronized (resourcePoolFactory) {
                fact.setMin(min);
                fact.setMax(max);
                fact.setIncrement(inc);
                fact.setIdleResourceTestPeriod(idleConnectionTestPeriod * 1000);
                fact.setResourceMaxAge(maxIdleTime * 1000);
                fact.setAcquisitionRetryAttempts(30);
                fact.setAgeIsAbsolute(false);
                this.rp = fact.createPool(manager);
            }
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource();
        }
        catch (Exception e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void checkinPooledConnection(PooledConnection pcon) throws SQLException {
        try {
            this.rp.checkinResource(pcon);
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.rp.close();
        }
        catch (ResourcePoolException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    public int getNumBusyConnections() throws SQLException {
        try {
            return this.rp.getAwaitingCheckinCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SqlUtils.toSQLException(e);
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent evt) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(evt.getSource());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            System.err.println("CONNECTION ERROR OCCURRED!");
            System.err.println();
            try {
                PooledConnection pc = (PooledConnection)evt.getSource();
                int status = pc instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pc).getConnectionStatus() : -1;
                switch (status) {
                    case 0: {
                        throw new InternalError("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pc);
                        break;
                    }
                    case -8: {
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new InternalError("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + status + ").");
                    }
                }
            }
            catch (ResourcePoolException e) {
                System.err.println("Uh oh... our resource pool is probably broken!");
                e.printStackTrace();
            }
        }
    }
}

