/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    public static final int ROLE_CARDINALITY_INFINITY = Integer.MAX_VALUE;
    private String myDescription;
    private boolean myIsReadableFlag;
    private boolean myIsWritableFlag;
    private int myMaxDegree;
    private int myMinDegree;
    private String myName;
    private String myRefMBeanClassName;

    public RoleInfo(RoleInfo info) throws IllegalArgumentException {
        this.myDescription = info.getDescription();
        this.myIsReadableFlag = info.isReadable();
        this.myIsWritableFlag = info.isWritable();
        this.myMaxDegree = info.getMaxDegree();
        this.myMinDegree = info.getMinDegree();
        this.myName = info.getName();
        this.myRefMBeanClassName = info.getRefMBeanClassName();
    }

    public RoleInfo(String name, String className) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this.myName = name;
        this.myRefMBeanClassName = className;
    }

    public RoleInfo(String name, String className, boolean isReadable, boolean isWritable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this.myName = name;
        this.myRefMBeanClassName = className;
        this.myIsReadableFlag = isReadable;
        this.myIsWritableFlag = isWritable;
    }

    public RoleInfo(String name, String className, boolean isReadable, boolean isWritable, int minDegree, int maxDegree, String description) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.myName = name;
        this.myRefMBeanClassName = className;
        this.myIsReadableFlag = isReadable;
        this.myIsWritableFlag = isWritable;
        this.myMinDegree = minDegree;
        this.myMaxDegree = maxDegree;
        this.myDescription = description;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isReadable() {
        return this.myIsReadableFlag;
    }

    public boolean isWritable() {
        return this.myIsWritableFlag;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int getMinDegree() {
        return this.myMinDegree;
    }

    public int getMaxDegree() {
        return this.myMaxDegree;
    }

    public String getRefMBeanClassName() {
        return this.myRefMBeanClassName;
    }

    public boolean checkMinDegree(int degree) {
        return this.myMinDegree <= degree;
    }

    public boolean checkMaxDegree(int degree) {
        return degree <= this.myMinDegree;
    }

    public String toString() {
        return "RoleInfo[name=" + this.myName + "]";
    }
}

