/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public class MimeType
implements Externalizable {
    private static final String TYPE_SEPARATOR = "/";
    private static final String PARAMETER_SEPARATOR = ";";
    private static final String STAR_SUB_TYPE = "*";
    private String primaryType = "text";
    private String subType = "plain";
    private MimeTypeParameterList parameterList = new MimeTypeParameterList();

    public MimeType() {
    }

    public MimeType(String rawdata) throws MimeTypeParseException {
        this.parseMimeType(rawdata);
    }

    public MimeType(String primary, String sub) throws MimeTypeParseException {
        this.setPrimaryType(primary);
        this.setSubType(sub);
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primary) throws MimeTypeParseException {
        this.primaryType = MimeType.parseToken(primary);
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String sub) throws MimeTypeParseException {
        this.subType = MimeType.parseToken(sub);
    }

    public MimeTypeParameterList getParameters() {
        return this.parameterList;
    }

    public String getParameter(String name) {
        return this.parameterList.get(name);
    }

    public void setParameter(String name, String value) {
        this.parameterList.set(name, value);
    }

    public void removeParameter(String name) {
        this.parameterList.remove(name);
    }

    public String toString() {
        return this.getBaseType() + (this.parameterList == null ? "" : PARAMETER_SEPARATOR + this.parameterList.toString());
    }

    public String getBaseType() {
        return this.getPrimaryType() + TYPE_SEPARATOR + this.getSubType();
    }

    public boolean match(MimeType type) {
        return this.getPrimaryType().equals(type.getPrimaryType()) && (this.getSubType().equals(STAR_SUB_TYPE) || type.getSubType().equals(STAR_SUB_TYPE) || this.getSubType().equals(type.getSubType()));
    }

    public boolean match(String rawdata) throws MimeTypeParseException {
        return this.match(new MimeType(rawdata));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.toString());
        out.flush();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.parseMimeType(in.readUTF());
        }
        catch (MimeTypeParseException mtpex) {
            throw new IOException(mtpex.getMessage());
        }
    }

    private void parseMimeType(String rawData) throws MimeTypeParseException {
        int typeSeparatorPos = rawData.indexOf(TYPE_SEPARATOR);
        int parameterSeparatorPos = rawData.indexOf(PARAMETER_SEPARATOR);
        if (typeSeparatorPos < 0) {
            throw new MimeTypeParseException("Unable to find subtype");
        }
        this.setPrimaryType(rawData.substring(0, typeSeparatorPos));
        if (parameterSeparatorPos < 0) {
            this.setSubType(rawData.substring(typeSeparatorPos + 1));
        } else {
            this.setSubType(rawData.substring(typeSeparatorPos + 1, parameterSeparatorPos));
            this.parameterList = new MimeTypeParameterList(rawData.substring(parameterSeparatorPos + 1));
        }
    }

    private static String parseToken(String tokenString) {
        return tokenString;
    }
}

