/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message.util;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.capacity.BasicCapacityMonitor;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;

public class MemoryBoundedQueueManager
extends BasicCapacityMonitor {
    private static final int OBJECT_OVERHEAD = 50;
    SynchronizedLong totalMemoryUsedSize = new SynchronizedLong(0L);
    private ConcurrentHashMap activeQueues = new ConcurrentHashMap();
    private static final Log log = LogFactory.getLog((Class)MemoryBoundedQueueManager.class);

    public MemoryBoundedQueueManager(String name, long maxSize) {
        super(name, maxSize);
    }

    public MemoryBoundedQueue getMemoryBoundedQueue(String name) {
        MemoryBoundedQueue result = (MemoryBoundedQueue)this.activeQueues.get((Object)name);
        if (result == null) {
            result = new MemoryBoundedQueue(name, this);
            this.activeQueues.put((Object)name, (Object)result);
        }
        return result;
    }

    public void close() {
        Iterator i = this.activeQueues.values().iterator();
        while (i.hasNext()) {
            MemoryBoundedQueue mbq = (MemoryBoundedQueue)i.next();
            mbq.close();
        }
        this.activeQueues.clear();
    }

    public long getTotalMemoryUsedSize() {
        return this.totalMemoryUsedSize.get();
    }

    public boolean isFull() {
        boolean result = this.totalMemoryUsedSize.get() >= super.getValueLimit();
        return result;
    }

    int incrementMemoryUsed(Packet obj) {
        int size = 50;
        if (obj != null) {
            if (obj.getMemoryUsageReferenceCount() == 0) {
                size += obj.getMemoryUsage();
            }
            obj.incrementMemoryReferenceCount();
        }
        this.totalMemoryUsedSize.add((long)size);
        super.setCurrentValue(this.totalMemoryUsedSize.get());
        return size;
    }

    int decrementMemoryUsed(Packet obj) {
        int size = 50;
        if (obj != null) {
            obj.decrementMemoryReferenceCount();
            if (obj.getMemoryUsageReferenceCount() == 0) {
                size += obj.getMemoryUsage();
            }
        }
        this.totalMemoryUsedSize.subtract((long)size);
        super.setCurrentValue(this.totalMemoryUsedSize.get());
        return size;
    }

    protected void finalize() {
        this.close();
    }

    void removeMemoryBoundedQueue(String name) {
        this.activeQueues.remove((Object)name);
    }
}

