/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    ConnectionTester connectionTester = C3P0Defaults.connectionTester();

    public WrapperConnectionPoolDataSource() {
        VetoableChangeListener setConnectionTesterListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Object val = evt.getNewValue();
                try {
                    if ("connectionTesterClassName".equals(evt.getPropertyName())) {
                        WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)val);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new PropertyVetoException("Could not instantiate connection tester class with name '" + val + "'.", evt);
                }
            }
        };
        this.addVetoableChangeListener(setConnectionTesterListener);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new C3P0PooledConnection(this.getNestedDataSource().getConnection(), this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new C3P0PooledConnection(this.getNestedDataSource().getConnection(user, password), this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getNestedDataSource().setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void recreateConnectionTester(String className) throws Exception {
        ConnectionTester ct;
        this.connectionTester = className != null ? (ct = (ConnectionTester)Class.forName(className).newInstance()) : C3P0Defaults.connectionTester();
    }
}

