/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.BASE64MailboxDecoder;
import java.util.Vector;

public class Namespaces {
    public Namespace[] personal;
    public Namespace[] otherUsers;
    public Namespace[] shared;

    public Namespaces(Response response) throws ProtocolException {
        this.personal = this.getNamespaces(response);
        this.otherUsers = this.getNamespaces(response);
        this.shared = this.getNamespaces(response);
    }

    private Namespace[] getNamespaces(Response response) throws ProtocolException {
        response.skipSpaces();
        if (response.peekByte() == 40) {
            Object[] objectArray;
            Vector<Object[]> vector = new Vector<Object[]>();
            response.readByte();
            do {
                objectArray = new Namespace(response);
                vector.addElement(objectArray);
            } while (response.peekByte() != 41);
            response.readByte();
            objectArray = new Namespace[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String string = response.readAtom();
        if (string == null) {
            throw new ProtocolException("Expected NIL, got null");
        }
        if (!string.equalsIgnoreCase("NIL")) {
            throw new ProtocolException("Expected NIL, got " + string);
        }
        return null;
    }

    public static class Namespace {
        public String prefix;
        public char delimiter;

        public Namespace(Response response) throws ProtocolException {
            if (response.readByte() != 40) {
                throw new ProtocolException("Missing '(' at start of Namespace");
            }
            this.prefix = BASE64MailboxDecoder.decode(response.readString());
            response.skipSpaces();
            if (response.peekByte() == 34) {
                response.readByte();
                this.delimiter = (char)response.readByte();
                if (response.readByte() != 34) {
                    throw new ProtocolException("Missing '\"' at end of QUOTED_CHAR");
                }
            } else {
                String string = response.readAtom();
                if (string == null) {
                    throw new ProtocolException("Expected NIL, got null");
                }
                if (!string.equalsIgnoreCase("NIL")) {
                    throw new ProtocolException("Expected NIL, got " + string);
                }
                this.delimiter = '\u0000';
            }
            if (response.peekByte() != 41) {
                response.skipSpaces();
                response.readString();
                response.skipSpaces();
                response.readStringList();
            }
            if (response.readByte() != 41) {
                throw new ProtocolException("Missing ')' at end of Namespace");
            }
        }
    }
}

