/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESThunk;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;

class NativeNumber
extends Native {
    static final int NEW = 1;
    static final int TO_STRING = 2;
    static final int VALUE_OF = 3;

    private NativeNumber(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        NativeNumber nativeNum = new NativeNumber("Number", 1, 1);
        ESWrapper numProto = new ESWrapper("Number", (ESBase)resin.objProto, ESNumber.create(0.0));
        NativeWrapper num = new NativeWrapper(resin, nativeNum, numProto, 11);
        resin.numProto = numProto;
        int flags = 4;
        int allflags = 7;
        numProto.put(ESId.intern("toString"), (ESBase)new NativeNumber("toString", 2, 0), flags);
        numProto.put(ESId.intern("valueOf"), (ESBase)new NativeNumber("valueOf", 3, 0), flags);
        num.put("length", (ESBase)ESNumber.create(1.0), allflags);
        num.put("MAX_VALUE", (ESBase)ESNumber.create(Double.MAX_VALUE), allflags);
        num.put("MIN_VALUE", (ESBase)ESNumber.create(Double.MIN_VALUE), allflags);
        num.put("NaN", (ESBase)ESNumber.create(Double.NaN), allflags);
        num.put("NEGATIVE_INFINITY", (ESBase)ESNumber.create(Double.NEGATIVE_INFINITY), allflags);
        num.put("POSITIVE_INFINITY", (ESBase)ESNumber.create(Double.POSITIVE_INFINITY), allflags);
        numProto.setClean();
        num.setClean();
        return num;
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                if (length == 0) {
                    return ESNumber.create(0.0);
                }
                return ESNumber.create(eval.getArg(0).toNum());
            }
            case 2: {
                try {
                    return ((ESWrapper)eval.getArg((int)-1)).value.toStr();
                }
                catch (ClassCastException e) {
                    if (eval.getArg(-1) instanceof ESNumber) {
                        return eval.getArg(-1);
                    }
                    if (eval.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)eval.getArg((int)-1)).getObject()).value.toStr();
                    }
                    throw new ESException("toString expected number object");
                }
            }
            case 3: {
                try {
                    return ((ESWrapper)eval.getArg((int)-1)).value;
                }
                catch (ClassCastException e) {
                    if (eval.getArg(-1) instanceof ESNumber) {
                        return eval.getArg(-1);
                    }
                    if (eval.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)eval.getArg((int)-1)).getObject()).value;
                    }
                    throw new ESException("valueOf expected number object");
                }
            }
        }
        throw new RuntimeException("Unknown object function");
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != 1) {
            return super.construct(eval, length);
        }
        ESNumber value = length == 0 ? ESNumber.create(0.0) : ESNumber.create(eval.getArg(0).toNum());
        return ((ESBase)value).toObject();
    }
}

