/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.Parser;
import com.caucho.es.parser.RegexpExpr;
import com.caucho.es.parser.SpecialExpr;
import com.caucho.es.parser.TopExpr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.es.parser.Variable;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import java.util.ArrayList;
import java.util.HashMap;

class Block {
    private static FreeList freeList = new FreeList(16);
    private static HashMap specialNames = new HashMap();
    Function function;
    private Block parent;
    private Expr lastExpr;
    boolean isDead;
    private boolean hasStatementValue;
    private Parser parser;
    private boolean isLoop;
    private boolean canExit;
    private boolean hasDefault;
    private int withDepth;
    private ESId id;
    private Expr mark;
    private Object switchTop;
    private Object top;
    private int topMark;

    private Block() {
    }

    Block create() throws ESException {
        this.evalExpr();
        Block block = new Block();
        block.function = this.function;
        block.parent = this;
        block.lastExpr = null;
        block.isDead = false;
        block.hasStatementValue = this.hasStatementValue;
        block.parser = this.parser;
        block.isLoop = false;
        block.canExit = false;
        block.withDepth = this.withDepth;
        block.id = null;
        block.mark = null;
        block.switchTop = null;
        block.top = null;
        block.setTop();
        return block;
    }

    static Block create(Parser parser, Function function) {
        Block block = new Block();
        block.function = function;
        block.parent = null;
        block.lastExpr = null;
        block.isDead = false;
        block.hasStatementValue = function.needsStatementResults();
        block.parser = parser;
        block.isLoop = false;
        block.canExit = false;
        block.withDepth = 0;
        block.id = null;
        block.top = null;
        block.topMark = 0;
        function.setVars();
        return block;
    }

    ClassLoader getClassLoader() {
        return this.parser.getClassLoader();
    }

    void setTop() {
        this.top = this.function.getTop();
        if (this.top instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)this.top;
            this.topMark = cb.length();
        } else {
            this.topMark = 0;
        }
    }

    Block pop() {
        Block parent = this.parent;
        this.function.setVars();
        freeList.free(this);
        return parent;
    }

    boolean isGlobal() {
        return this.function.isGlobal();
    }

    int getDepth() {
        return this.withDepth;
    }

    boolean allowSpecial() {
        return this.parent == null;
    }

    String getFilename() {
        String filename = this.parser.lexer.getLastFilename();
        int p = filename.lastIndexOf(47);
        if (p > 0) {
            filename = filename.substring(p + 1);
        }
        if ((p = filename.lastIndexOf(92)) > 0) {
            filename = filename.substring(p + 1);
        }
        return filename;
    }

    int getLine() {
        int line = this.parser.lexer.getLastLine();
        return line;
    }

    void setLine(int line) {
    }

    boolean hasVar(ESId name) {
        return this.function.hasVar(name) || specialNames.get(name) != null;
    }

    IdExpr newVar(ESId name) {
        return this.newVar(name, null);
    }

    IdExpr newVar(ESId name, Expr type) {
        if (this.withDepth > 0) {
            return new IdExpr(this, new Variable(this, name, type, false));
        }
        IdExpr expr = this.function.newVar(this, name, type);
        if (this.parent != null) {
            expr.getType();
        }
        return expr;
    }

    void defVar(ESId name) {
        this.function.addVariable(this, name, null);
    }

    void defVar(ESId name, Expr type) {
        this.function.addVariable(this, name, type);
    }

    Expr newLiteral(ESBase value) {
        return new LiteralExpr(this, value);
    }

    Expr newRegexp(ESBase value, String flags) throws ESException {
        return new RegexpExpr(this, value, flags);
    }

    Expr newThis() {
        return new SpecialExpr(this, 116);
    }

    Expr newArray(Expr expr) {
        return new SpecialExpr(this, 97, expr);
    }

    Expr hasNext(String iter) {
        return new SpecialExpr(this, 109, iter);
    }

    Expr newType(ESId name) {
        return TypeExpr.create(this, name);
    }

    void addExpr(Expr expr) throws ESException {
        if (this.isDead) {
            throw this.error("Statement is unreachable.");
        }
        if (this.lastExpr != null) {
            this.lastExpr.exprStatement(this.function);
        }
        if (this.hasStatementValue && !Void.TYPE.equals(expr.getJavaClass())) {
            this.lastExpr = expr;
        } else {
            this.lastExpr = null;
            expr.exprStatement(this.function);
        }
    }

    Block startBlock() throws ESException {
        this.evalExpr();
        this.function.println("{");
        return this.create();
    }

    Block startBlock(ESId id) throws ESException {
        if (this.findBlock(id) != null) {
            throw this.error("duplicate label `" + id + "'");
        }
        this.evalExpr();
        Block block = this.create();
        block.id = id;
        this.function.println(id + ": {");
        block.setTop();
        return block;
    }

    Block finishBlock() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.id = null;
        Block old = this.pop();
        if (this.isDead && !this.canExit) {
            old.isDead = true;
        }
        return old;
    }

    void endBlock() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.id = null;
    }

    void startIf(Expr expr, boolean isElse) throws ESException {
        this.evalExpr();
        if (isElse) {
            this.function.print(" else ");
        }
        this.function.print("if (");
        this.function.addBoolean(expr);
        this.function.println(") {");
        this.setTop();
    }

    void startElse() throws ESException {
        this.evalExpr();
        this.function.println(" else {");
        this.setTop();
    }

    Block startWhile(ESId id, Expr expr) throws ESException {
        this.evalExpr();
        if (id != null) {
            this.function.println(id + ":");
        }
        this.function.print("while (");
        this.function.addBoolean(expr);
        this.function.println(") {");
        Block block = this.create();
        this.startLoop(id);
        if (!(expr instanceof LiteralExpr) || !((LiteralExpr)expr).getLiteral().toBoolean()) {
            this.canExit = true;
        }
        return block;
    }

    Block startFor(ESId id, Expr test, Expr incr) throws ESException {
        this.evalExpr();
        if (id != null) {
            this.function.println(id + ":");
        }
        this.function.print("for (;");
        if (test != null) {
            this.function.addBoolean(test);
        }
        this.function.print(";");
        if (incr != null) {
            this.function.addExpr(incr);
        }
        this.function.println(") {");
        this.function.cl.pushDepth();
        Block block = this.create();
        this.startLoop(id);
        if (test == null) {
            this.canExit = false;
        } else if (!(test instanceof LiteralExpr) || !((LiteralExpr)test).getLiteral().toBoolean()) {
            this.canExit = true;
        }
        return block;
    }

    Block startDo(ESId id) throws ESException {
        this.evalExpr();
        if (id != null) {
            this.function.println(id + ":");
        }
        this.function.print("do {");
        Block block = this.create();
        this.startLoop(id);
        return block;
    }

    Block endDo(Expr expr) throws ESException {
        this.evalExpr();
        Block old = this.endLoop();
        if (!(expr instanceof LiteralExpr) || !((LiteralExpr)expr).getLiteral().toBoolean()) {
            old.canExit = true;
        }
        if (old.canExit) {
            old.isDead = false;
        }
        this.function.print("while (");
        this.function.addBoolean(expr);
        this.function.println(");");
        return old;
    }

    void startLoop(ESId id) {
        String oldVar = this.function.getStatementVar();
        this.function.pushStatementLoop();
        String newVar = this.function.getStatementVar();
        if (oldVar != null) {
            this.function.println(newVar + " = " + oldVar + ";");
        }
        this.id = id;
        this.isLoop = true;
        this.canExit = false;
    }

    Block endLoop() throws ESException {
        this.evalExpr();
        String newVar = this.function.getStatementVar();
        this.function.popStatementLoop();
        String oldVar = this.function.getStatementVar();
        if (oldVar != null && !this.isDead) {
            this.function.println(oldVar + " = " + newVar + ";");
        }
        this.function.cl.popDepth();
        this.function.println("}");
        Block old = this.pop();
        if (!old.canExit) {
            old.isDead = true;
        }
        return old;
    }

    Block startSwitch(Expr test) throws ESException {
        ESId id = ESId.intern("_switchtemp");
        this.function.print("_switchtemp = ");
        this.function.addExpr(test);
        this.function.println(";");
        Block block = this.create();
        block.switchTop = this.function.getSwitch();
        block.isLoop = true;
        block.hasDefault = false;
        this.function.println("switch (_switchcode) {");
        return block;
    }

    void doCase(int i) throws ESException {
        this.isDead = false;
        this.evalExpr();
        this.function.println("case " + i + ":");
    }

    void doDefault() throws ESException {
        this.isDead = false;
        this.hasDefault = true;
        this.evalExpr();
        this.function.println("default:");
    }

    Block fillSwitch(ArrayList exprs) throws ESException {
        this.evalExpr();
        if (!this.hasDefault && !this.isDead) {
            this.function.println("default:");
            this.function.println("  break;");
        } else if (!this.isDead) {
            this.function.println("break;");
        }
        this.function.println("}");
        int mark = this.function.mark();
        for (int i = 0; i < exprs.size(); ++i) {
            if (i != 0) {
                this.function.print("else ");
            }
            Expr test = (Expr)exprs.get(i);
            this.function.print("if (_switchtemp.equals(");
            this.function.addExpr(test);
            this.function.println(")) _switchcode = " + i + ";");
        }
        if (exprs.size() > 0) {
            this.function.print("else ");
        }
        this.function.println("_switchcode = -1;");
        this.function.moveChunk(this.switchTop, mark);
        Block old = this.pop();
        if (this.isDead && !this.canExit && this.hasDefault) {
            old.isDead = true;
        }
        return old;
    }

    void doBreak(ESId id) throws ESException {
        Block block = this;
        while (block != null) {
            if (block.id == id) {
                block.canExit = true;
                break;
            }
            block = block.parent;
        }
        if (block == null) {
            throw this.error("break needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("break " + id + ";");
        this.isDead = true;
    }

    void doBreak() throws ESException {
        Block block = this;
        while (block != null) {
            if (block.isLoop) {
                block.canExit = true;
                break;
            }
            block = block.parent;
        }
        if (block == null) {
            throw this.error("break needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("break;");
        this.isDead = true;
    }

    void doContinue(ESId id) throws ESException {
        Block block = this;
        while (!(block == null || block.id == id && block.isLoop)) {
            block = block.parent;
        }
        if (block == null) {
            throw this.error("continue needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("continue " + id + ";");
        this.isDead = true;
    }

    void doContinue() throws ESException {
        if (this.findBlock(null) == null) {
            throw this.error("continue needs enclosing loop");
        }
        this.function.setVars();
        this.evalExpr();
        this.function.println("continue;");
        this.isDead = true;
    }

    private Block findBlock(ESId id) {
        Block block = this;
        while (block != null) {
            if (id != null && block.id == id) {
                return block;
            }
            if (id == null && block.isLoop) {
                return block;
            }
            block = block.parent;
        }
        return null;
    }

    Block startWith(Expr expr) throws ESException {
        this.function.setArguments();
        this.function.setUseAllVariables();
        this.evalExpr();
        ++this.withDepth;
        this.function.println("try {");
        this.function.print("_env.pushScope(");
        this.function.addExpr(expr);
        this.function.println(");");
        this.setTop();
        return this;
    }

    Block endWith() throws ESException {
        this.evalExpr();
        --this.withDepth;
        this.function.println("} finally {");
        this.function.println("_env.popScope();");
        this.function.println("}");
        return this;
    }

    int getWithDepth() {
        return this.withDepth;
    }

    Block startTry() throws ESException {
        this.function.setVars();
        this.evalExpr();
        this.function.println("try {");
        return this;
    }

    Block endTry() throws ESException {
        this.function.setVars();
        this.evalExpr();
        this.function.println("}");
        return this;
    }

    void doTry() throws ESException {
        int i;
        this.evalExpr();
        for (i = 0; i < this.function.data.size(); ++i) {
            Object o = this.function.data.get(i);
            if (o != this.top) continue;
            if (o instanceof CharBuffer) {
                CharBuffer cb = (CharBuffer)o;
                cb.insert(this.topMark, " try {\n");
                break;
            }
            this.function.data.add(i + 1, new CharBuffer(" try {\n"));
            break;
        }
        if (i >= this.function.data.size()) {
            if (this.function.tail != null && this.top == this.function.tail) {
                this.function.tail.insert(this.topMark, " try {\n");
            } else {
                this.function.data.add(0, new CharBuffer(" try {\n"));
            }
        }
        this.function.println("}");
    }

    Block startCatch(String exn, Expr var) throws ESException {
        this.evalExpr();
        String temp = "_e" + this.function.getTemp();
        this.function.println("catch (" + exn + " " + temp + ") {");
        if (var != null) {
            SpecialExpr expr = new SpecialExpr(this, 101, temp);
            var.assign(expr).exprStatement(this.function);
        }
        this.isDead = false;
        this.setTop();
        return this;
    }

    Block endCatch() throws ESException {
        this.evalExpr();
        this.function.println("}");
        return this;
    }

    Block startFinally() throws ESException {
        this.evalExpr();
        Block block = this.create();
        this.function.println("finally {");
        this.function.pushStatementLoop();
        block.setTop();
        return block;
    }

    Block endFinally() throws ESException {
        this.evalExpr();
        this.function.println("}");
        this.function.popStatementLoop();
        return this.pop();
    }

    Block startSynchronized(Expr expr) throws ESException {
        this.evalExpr();
        this.function.print("synchronized (");
        this.function.addExpr(expr);
        this.function.println(".toJavaObject()) {");
        return this.create();
    }

    Block endSynchronized() throws ESException {
        this.evalExpr();
        this.function.println("}");
        Block old = this.pop();
        old.isDead = this.isDead;
        return old;
    }

    void doThrow(Expr expr) throws ESException {
        this.function.print("throw (Exception)");
        this.function.addExpr(expr);
        this.function.println(".toJavaObject();");
        this.isDead = true;
    }

    void doReturn(Expr value) throws ESException {
        this.evalExpr();
        this.function.print("return ");
        value.setUsed();
        if (this.function.getReturnType() != null) {
            this.function.addExpr(new TopExpr(this, value, this.function.getReturnType()));
        } else {
            this.function.addExpr(value);
        }
        this.function.println(";");
        this.isDead = true;
    }

    void doReturn() throws ESException {
        this.evalExpr();
        if (this.function.getReturnType() != null) {
            this.function.print("return 0;");
        } else {
            this.function.print("return ESBase.esUndefined;");
        }
        this.isDead = true;
    }

    void finish() throws ESException {
        if (this.isDead) {
            return;
        }
        if (this.lastExpr != null) {
            this.function.print("return ");
            this.function.addExpr(this.lastExpr);
            this.function.println(";");
            this.lastExpr = null;
        } else if (this.hasStatementValue) {
            this.function.println("return _val0;");
        } else {
            this.function.println("return ESBase.esUndefined;");
        }
    }

    String newIterator(ESId id, Expr expr) throws ESException {
        this.evalExpr();
        String iter = "iter" + this.function.getIter();
        this.function.print(iter + " = ");
        this.function.addExpr(expr);
        this.function.println(".keys();");
        return iter;
    }

    void evalExpr() throws ESException {
        if (this.lastExpr == null) {
            return;
        }
        this.function.print(this.function.getStatementVar() + " = ");
        this.function.addExpr(this.lastExpr);
        this.function.println(";");
        this.lastExpr = null;
    }

    private static Block allocate() {
        Block block = (Block)freeList.allocate();
        if (block == null) {
            block = new Block();
        }
        return block;
    }

    ESException error(String message) {
        return this.parser.lexer.error(message);
    }

    void free() {
        freeList.free(this);
    }

    static {
        specialNames.put(ESId.intern("Object"), "Object");
        specialNames.put(ESId.intern("Date"), "Date");
        specialNames.put(ESId.intern("String"), "String");
        specialNames.put(ESId.intern("Number"), "Number");
        specialNames.put(ESId.intern("Array"), "Array");
        specialNames.put(ESId.intern("Boolean"), "Boolean");
        specialNames.put(ESId.intern("Math"), "Math");
    }
}

