/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.filter;

import com.caucho.http.filter.CauchoResponseWrapper;
import com.caucho.server.http.CauchoResponse;
import com.caucho.vfs.GzipStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GzipFilter
implements Filter {
    private boolean _useVary = true;
    private boolean _noCache = false;
    private ServletContext _app;
    private boolean _embedError;

    public void init(FilterConfig config) throws ServletException {
        String value = config.getInitParameter("use-vary");
        if ("false".equals(value)) {
            this._useVary = false;
            this._noCache = true;
        }
        if ("true".equals(value = config.getInitParameter("no-cache"))) {
            this._noCache = true;
        }
        this._app = config.getServletContext();
        this._embedError = "true".equals(config.getInitParameter("embed-error-in-output"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this._noCache) {
            res.setHeader("Cache-Control", "no-cache");
        } else if (this._useVary) {
            res.addHeader("Vary", "Accept-Encoding");
        } else {
            res.setHeader("Cache-Control", "private");
        }
        boolean allowGzip = false;
        String acceptEncoding = req.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.indexOf("gzip") >= 0 && request.getAttribute("caucho.http.filter.GzipFilter") == null) {
            allowGzip = true;
        }
        if (allowGzip) {
            GzipResponse gzipResponse = new GzipResponse(res);
            request.setAttribute("com.caucho.http.filter.GzipFilter", (Object)"true");
            try {
                nextFilter.doFilter((ServletRequest)req, (ServletResponse)gzipResponse);
            }
            catch (Throwable e) {
                this.handleError(e, gzipResponse);
            }
            gzipResponse.close();
        } else {
            nextFilter.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    public void destroy() {
    }

    private void handleError(Throwable e, CauchoResponseWrapper res) throws ServletException, IOException {
        if (!this._embedError || !res.isCommitted()) {
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new ServletException(e);
        }
        this._app.log(e.getMessage(), e);
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.flush();
        res.getStream().print(writer.toCharArray());
    }

    static class GzipResponse
    extends CauchoResponseWrapper {
        private boolean _allowGzip = true;
        private GzipStream _gzipStream;

        GzipResponse(HttpServletResponse response) {
            super(response);
        }

        public void setContentLength(int length) {
        }

        public void setStatus(int status, String message) {
            super.setStatus(status, message);
            if (this._gzipStream != null) {
                this._gzipStream.setEnable(false);
                this._response.setHeader("Content-Encoding", "plain");
            }
            this._allowGzip = false;
        }

        public void setStatus(int status) {
            super.setStatus(status);
            if (this._gzipStream != null) {
                this._gzipStream.setEnable(false);
                this._response.setHeader("Content-Encoding", "plain");
            }
            this._allowGzip = false;
        }

        public WriteStream getStream() throws IOException {
            if (this._stream != null) {
                return this._stream;
            }
            if (!this._allowGzip) {
                if (this._response instanceof CauchoResponse) {
                    this._stream = ((CauchoResponse)this._response).getStream();
                } else {
                    ServletOutputStream os = this._response.getOutputStream();
                    this._stream = Vfs.openWrite((OutputStream)os);
                }
                return this._stream;
            }
            Object os = this._response instanceof CauchoResponse ? ((CauchoResponse)this._response).getStream() : this._response.getOutputStream();
            this._response.setHeader("Content-Encoding", "gzip");
            this._gzipStream = new GzipStream((OutputStream)os);
            this._stream = this._writeStream = new WriteStream();
            this._stream.init(this._gzipStream);
            String charset = this.getCharacterEncoding();
            this._stream.setEncoding(charset);
            return this._stream;
        }

        public void flush() throws IOException {
            if (this._stream != null) {
                this._stream.flush();
            }
        }
    }
}

