/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.server;

import com.caucho.http.server.FastCGIResponse;
import com.caucho.http.server.FastCGIStreamImpl;
import com.caucho.server.Connection;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.IntMap;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;

public class FastCGIRequest
extends Request {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/fcgi");
    private static final int FCGI_BEGIN_REQUEST = 1;
    private static final int FCGI_ABORT_REQUEST = 2;
    private static final int FCGI_END_REQUEST = 3;
    private static final int FCGI_PARAMS = 4;
    private static final int FCGI_STDIN = 5;
    private static final int FCGI_STDOUT = 6;
    private static final int FCGI_STDERR = 7;
    private static final int FCGI_DATA = 8;
    private static final int FCGI_GET_VALUES = 9;
    private static final int FCGI_GET_VALUES_RESULT = 10;
    private static final int FCGI_UNKNOWNE_TYPE = 11;
    private static final int IGNORE = 0;
    private static final int REQUEST_URI = 1;
    private static final int REQUEST_METHOD = 2;
    private static final int SERVER_PROTOCOL = 3;
    private static IntMap knownHeaders;
    static char[] hostCb;
    private FastCGIStreamImpl streamImpl;
    private ReadStream rawRead;
    private WriteStream rawWrite;
    private ReadStream readStream;
    private WriteStream writeStream;
    private FastCGIInputStream fcgiIs;
    private InvocationKey invocationKey = new InvocationKey();
    private ByteBuffer uriBuffer = new ByteBuffer();
    private CharBuffer methodBuffer = new CharBuffer();
    private CharBuffer protocolBuffer = new CharBuffer();
    private CharSegment host;
    private CharBuffer[] headerKeys;
    private CharBuffer[] headerValues;
    private int headerSize;
    private CharBuffer headerBuffer = new CharBuffer();
    private CharBuffer valueBuffer = new CharBuffer();
    private String uri;
    private String method;

    FastCGIRequest(ServletServer server) {
        super(server);
        this.response = new FastCGIResponse(this);
        this.readStream = new ReadStream();
        this.readStream.setReuseBuffer(true);
        this.writeStream = new WriteStream();
        this.writeStream.setReuseBuffer(true);
        ((FastCGIResponse)this.response).init(this, this.writeStream);
        this.streamImpl = new FastCGIStreamImpl();
        this.headerKeys = new CharBuffer[32];
        this.headerValues = new CharBuffer[32];
        for (int i = 0; i < this.headerKeys.length; ++i) {
            this.headerKeys[i] = new CharBuffer();
            this.headerValues[i] = new CharBuffer();
        }
    }

    public void handleConnection(Connection conn) throws IOException {
        this.setConnection(conn);
        this.rawRead = conn.getReadStream();
        this.rawWrite = conn.getWriteStream();
        if (dbg.canWrite()) {
            dbg.println("[" + conn.getId() + "] start connection");
        }
        while (this.handleRequest()) {
        }
        if (dbg.canWrite()) {
            dbg.println("[" + conn.getId() + "] close connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleRequest() throws IOException {
        int headerLen;
        FastCGIInputStream is = this.fcgiIs = new FastCGIInputStream(this.rawRead);
        this.host = null;
        while ((headerLen = is.read()) >= 0) {
            int valueLen;
            if ((headerLen & 0x80) != 0) {
                headerLen = ((headerLen & 0x7F) << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
            }
            if (((valueLen = is.read()) & 0x80) != 0) {
                valueLen = ((valueLen & 0x7F) << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
            }
            this.headerBuffer.clear();
            this.headerBuffer.ensureCapacity(headerLen);
            is.read(this.headerBuffer.getBuffer(), 0, headerLen);
            this.headerBuffer.setLength(headerLen);
            this.valueBuffer.clear();
            this.valueBuffer.ensureCapacity(valueLen);
            is.read(this.valueBuffer.getBuffer(), 0, valueLen);
            this.valueBuffer.setLength(valueLen);
            this.addHeader(this.headerBuffer, this.valueBuffer);
        }
        is.finishHeaders();
        try {
            try {
                this.streamImpl.init(this.rawRead, this.rawWrite);
                this.readStream.init(new VfsStream(is, null), null);
                this.writeStream.init(this.streamImpl);
                this.start(this.readStream);
                this.invocationKey.init(this.getHost(), this.getServerPort(), this.uriBuffer.getBuffer(), this.uriBuffer.getLength(), false);
                this.server.serviceTop(this.invocationKey, this, this.response);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var6_5 = null;
                this.response.finish(false);
                this.writeStream.close();
                this.rawWrite.flush();
                return is.isKeepalive();
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.response.finish(false);
            this.writeStream.close();
            this.rawWrite.flush();
            throw throwable;
        }
        this.response.finish(false);
        this.writeStream.close();
        this.rawWrite.flush();
        return is.isKeepalive();
    }

    private void addHeader(CharBuffer headerBuffer, CharBuffer valueBuffer) {
        switch (knownHeaders.get(headerBuffer)) {
            case 0: {
                return;
            }
            case 1: {
                this.uriBuffer.clear();
                this.uriBuffer.add(valueBuffer.getBuffer(), 0, valueBuffer.getLength());
                return;
            }
            case 2: {
                this.methodBuffer.clear();
                this.methodBuffer.append(valueBuffer);
                return;
            }
            case 3: {
                this.protocolBuffer.clear();
                this.protocolBuffer.append(valueBuffer);
                return;
            }
        }
        if (this.headerSize >= this.headerKeys.length) {
            this.resizeHeaders();
        }
        CharBuffer key = this.headerKeys[this.headerSize];
        key.clear();
        int len = headerBuffer.length();
        if (headerBuffer.startsWith("HTTP_")) {
            for (int i = 5; i < len; ++i) {
                char ch = headerBuffer.charAt(i);
                if (ch == '_') {
                    key.append('-');
                    continue;
                }
                key.append(ch);
            }
        } else {
            key.append(headerBuffer);
        }
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(valueBuffer);
        ++this.headerSize;
    }

    private void resizeHeaders() {
        int i;
        CharBuffer[] newKeys = new CharBuffer[this.headerSize * 2];
        CharBuffer[] newValues = new CharBuffer[this.headerSize * 2];
        for (i = 0; i < this.headerSize; ++i) {
            newKeys[i] = this.headerKeys[i];
            newValues[i] = this.headerValues[i];
        }
        for (i = this.headerSize; i < newKeys.length; ++i) {
            newKeys[i] = new CharBuffer();
            newValues[i] = new CharBuffer();
        }
        this.headerKeys = newKeys;
        this.headerValues = newValues;
    }

    public CharSegment getHeaderBuffer(String key) {
        for (int i = 0; i < this.headerSize; ++i) {
            CharBuffer test = this.headerKeys[i];
            if (!test.equalsIgnoreCase(key)) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        for (int i = 0; i < this.headerSize; ++i) {
            int j;
            CharBuffer test = this.headerKeys[i];
            if (test.length() != length) continue;
            char[] keyBuf = test.getBuffer();
            for (j = 0; j < length; ++j) {
                char a = buf[j];
                char b = keyBuf[j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j != length) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public void setHeader(String key, String value) {
        this.headerKeys[this.headerSize].clear();
        this.headerKeys[this.headerSize].append(key);
        this.headerValues[this.headerSize].clear();
        this.headerValues[this.headerSize].append(value);
        ++this.headerSize;
    }

    public void getHeaderBuffers(ArrayList values, String key) {
        this.cb.clear();
        this.cb.append(key);
        int size = this.headerSize;
        for (int i = 0; i < size; ++i) {
            CharBuffer test = this.headerKeys[i];
            if (!test.equalsIgnoreCase(this.cb)) continue;
            values.add(this.headerValues[i]);
        }
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            names.add(this.headerKeys[i].toString());
        }
        return Collections.enumeration(names);
    }

    protected boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    public String getScheme() {
        return "http";
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasInputStream) {
            return this.is;
        }
        this.hasInputStream = true;
        this.is.init(this.readStream);
        return this.is;
    }

    public CharSegment getMethodBuffer() {
        return this.methodBuffer;
    }

    CharSegment getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = this.getHeaderBuffer(hostCb, hostCb.length);
        return this.host;
    }

    public byte[] getUriBuffer() {
        return this.uriBuffer.getBuffer();
    }

    public int getUriLength() {
        return this.uriBuffer.getLength();
    }

    public CharSegment getProtocolBuffer() {
        return this.protocolBuffer;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return null;
    }

    public void getRemoteAddr(CharBuffer cb) {
    }

    public String getRemoteHost() {
        return null;
    }

    static {
        hostCb = "Host".toCharArray();
        knownHeaders = new IntMap();
        knownHeaders.put(new CharBuffer("REQUEST_URI"), 1);
        knownHeaders.put(new CharBuffer("REQUEST_METHOD"), 2);
        knownHeaders.put(new CharBuffer("SERVER_PROTOCOL"), 3);
        knownHeaders.put(new CharBuffer("SERVER_NAME"), 0);
        knownHeaders.put(new CharBuffer("SERVER_PORT"), 0);
        knownHeaders.put(new CharBuffer("REMOTE_ADDR"), 0);
        knownHeaders.put(new CharBuffer("AUTH_TYPE"), 0);
        knownHeaders.put(new CharBuffer("SCRIPT_NAME"), 0);
        knownHeaders.put(new CharBuffer("PATH_INFO"), 0);
        knownHeaders.put(new CharBuffer("PATH_TRANSLATED"), 0);
    }

    static class FastCGIInputStream
    extends InputStream {
        private InputStream is;
        private int chunkLength;
        private int paddingLength;
        private boolean hasParam;
        private int stdinLength;
        private boolean isKeepalive;

        public FastCGIInputStream() {
        }

        public FastCGIInputStream(InputStream is) {
            this.init(is);
        }

        public void init(InputStream is) {
            this.is = is;
            this.chunkLength = 0;
            this.hasParam = false;
            this.stdinLength = 0;
            this.paddingLength = 0;
            this.isKeepalive = false;
        }

        public int read(char[] buffer, int offset, int length) throws IOException {
            int ch;
            int readLength;
            for (readLength = 0; readLength < length && (ch = this.read()) >= 0; ++readLength) {
                buffer[offset + readLength] = (char)ch;
            }
            if (readLength == 0) {
                return -1;
            }
            return readLength;
        }

        public void finishHeaders() {
            this.hasParam = true;
            this.chunkLength = this.stdinLength;
            if (this.chunkLength == 0) {
                this.is = null;
            }
        }

        public int read() throws IOException {
            if (this.chunkLength > 0) {
                --this.chunkLength;
                return this.is.read();
            }
            if (this.paddingLength > 0) {
                this.is.skip(this.paddingLength);
                this.paddingLength = 0;
            }
            if (!this.readNext()) {
                return -1;
            }
            --this.chunkLength;
            return this.is.read();
        }

        boolean isKeepalive() {
            return this.isKeepalive;
        }

        private boolean readNext() throws IOException {
            int version;
            if (this.is == null) {
                return false;
            }
            block5: while ((version = this.is.read()) >= 0) {
                int type = this.is.read();
                int id = (this.is.read() << 8) + this.is.read();
                int length = (this.is.read() << 8) + this.is.read();
                int padding = this.is.read();
                this.is.read();
                switch (type) {
                    case 1: {
                        int role = (this.is.read() << 8) + this.is.read();
                        int flags = this.is.read();
                        for (int i = 0; i < 5; ++i) {
                            this.is.read();
                        }
                        if (flags == 0) continue block5;
                        this.isKeepalive = true;
                        continue block5;
                    }
                    case 4: {
                        if (this.hasParam) {
                            this.is.skip(length + padding);
                            continue block5;
                        }
                        if (length == 0) {
                            this.is = null;
                            return false;
                        }
                        this.chunkLength = length;
                        this.paddingLength = padding;
                        return true;
                    }
                    case 5: {
                        if (this.hasParam) {
                            this.chunkLength = length;
                            this.paddingLength = padding;
                            if (this.chunkLength > 0) {
                                return true;
                            }
                            this.is = null;
                            return false;
                        }
                        this.stdinLength = length;
                        this.paddingLength = padding;
                        return false;
                    }
                }
                this.is.skip(length + padding);
            }
            return false;
        }
    }
}

