/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.session;

import com.caucho.http.distribution.DistributedObject;
import com.caucho.http.distribution.DistributionServer;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.http.distribution.Store;
import com.caucho.http.session.SessionManager;
import com.caucho.server.http.Application;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CacheListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.NullEnumeration;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionImpl
implements HttpSession,
CacheListener,
DistributedObject {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/session");
    static L10N L = new L10N(class$com$caucho$http$session$SessionImpl == null ? (class$com$caucho$http$session$SessionImpl = SessionImpl.class$("com.caucho.http.session.SessionImpl")) : class$com$caucho$http$session$SessionImpl);
    private String id;
    private final Object _lock = new Object();
    protected SessionManager manager;
    protected Store store;
    protected ObjectBacking backing;
    protected Map values;
    private long creationTime;
    long accessTime;
    long maxInactiveInterval;
    private boolean isNew = true;
    boolean isValid = true;
    boolean isClosed = false;
    boolean needsLoad;
    boolean inUse;
    private int srunIndex = -1;
    private String mangledId;
    public int updateCount = -1;
    private boolean hasChanged;
    static /* synthetic */ Class class$com$caucho$http$session$SessionImpl;

    public SessionImpl(SessionManager manager, String id, long creationTime) {
        this.manager = manager;
        this.store = manager.getSessionStore();
        this.creationTime = creationTime;
        this.accessTime = creationTime;
        this.maxInactiveInterval = manager.getSessionTimeout();
        this.id = id;
        char ch = id.charAt(0);
        if (ch >= 'a' && ch <= 'z') {
            this.srunIndex = ch - 97;
        }
        if (dbg.canWrite()) {
            dbg.log("create session " + id + " " + manager.getApplication());
        }
    }

    public ObjectBacking getBacking() {
        if (this.backing == null) {
            this.backing = this.manager.createBacking(this.id);
            this.backing.setObject(this);
        }
        return this.backing;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    int getSrunIndex() {
        return this.srunIndex;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int incrUpdateCount() {
        if (this.updateCount < 0) {
            this.updateCount = 1;
            return this.updateCount;
        }
        return ++this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    public long getLastAccessedTime() {
        return this.accessTime;
    }

    public int getMaxInactiveInterval() {
        if (this.maxInactiveInterval >= 0x3FFFFFFFFFFFFFFFL) {
            return -1;
        }
        return (int)(this.maxInactiveInterval / 1000L);
    }

    public void setMaxInactiveInterval(int value) {
        this.maxInactiveInterval = value < 0 ? 0x3FFFFFFFFFFFFFFFL : (long)value * 1000L;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public ServletContext getServletContext() {
        return this.manager.getApplication();
    }

    public SessionManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isValid) {
                throw new IllegalStateException(L.l("Can't call getAttribute() when session is no longer valid."));
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ArrayList listeners;
        HttpSessionBindingListener listener;
        Object oldValue;
        if (!this.isValid) {
            throw new IllegalStateException(L.l("Can't call setAttribute(String, Object) when session is no longer valid."));
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.values == null) {
                this.values = this.createValueMap();
            }
            oldValue = this.values.put(name, value);
        }
        this.setChanged();
        if (oldValue instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if (value instanceof HttpSessionBindingListener) {
            listener = (HttpSessionBindingListener)value;
            listener.valueBound(new HttpSessionBindingEvent((HttpSession)this, name, value));
        }
        if ((listeners = this.manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = oldValue != null ? new HttpSessionBindingEvent((HttpSession)this, name, oldValue) : new HttpSessionBindingEvent((HttpSession)this, name, value);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener2 = (HttpSessionAttributeListener)listeners.get(i);
                if (oldValue != null) {
                    listener2.attributeReplaced(event);
                    continue;
                }
                listener2.attributeAdded(event);
            }
        }
    }

    protected Map createValueMap() {
        return new HashMap(8);
    }

    public void setChanged() {
        this.hasChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        if (!this.isValid) {
            throw new IllegalStateException(L.l("Can't call removeAttribute(String) when session is no longer valid."));
        }
        if (this.values == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            oldValue = this.values.remove(name);
        }
        this.hasChanged = true;
        this.notifyValueUnbound(name, oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isValid) {
                throw new IllegalStateException(L.l("Can't call getAttributeNames() when session is no longer valid."));
            }
            if (this.values == null) {
                return NullEnumeration.create();
            }
            return Collections.enumeration(this.values.keySet());
        }
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isValid) {
                throw new IllegalStateException(L.l("Can't call getValueNames() when session is no longer valid."));
            }
            if (this.values == null) {
                return new String[0];
            }
            String[] s = new String[this.values.size()];
            Enumeration e = this.getAttributeNames();
            int count = 0;
            while (e.hasMoreElements()) {
                s[count++] = (String)e.nextElement();
            }
            return s;
        }
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException(L.l("Can't call isNew() when session is no longer valid."));
        }
        return this.isNew;
    }

    public boolean isValid() {
        return this.isValid;
    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void removeEvent() {
        this.manager.decrementSessionCount();
        if (dbg.canWrite()) {
            dbg.log("lru-drop session " + this.id + " " + this.manager.getApplication());
        }
        this.callDestroyListeners();
        if (this.manager.isClosed()) {
            this.invalidateLocal();
        } else if (this.srunIndex == this.manager.getSrunIndex() || this.manager.getSrunIndex() < 0) {
            this.invalidateImpl();
        } else {
            this.invalidateLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        boolean invalidateAfterListener;
        if (!this.isValid) {
            throw new IllegalStateException(L.l("Can't call invalidate() when session is no longer valid."));
        }
        if (dbg.canWrite()) {
            dbg.log("invalidate session " + this.id + " " + this.manager.getApplication());
        }
        if (!(invalidateAfterListener = this.manager.isInvalidateAfterListener())) {
            this.isValid = false;
        }
        try {
            this.manager.removeSession(this);
            this.invalidateImpl();
        }
        finally {
            this.isValid = false;
        }
    }

    void invalidateImpl() {
        boolean invalidateAfterListener = this.manager.isInvalidateAfterListener();
        if (!invalidateAfterListener) {
            this.isValid = false;
        }
        try {
            if (this.store != null) {
                this.store.remove(this);
            }
        }
        catch (Throwable e) {
            dbg.log(e);
        }
        this.invalidateLocal();
    }

    public void invalidateLocal() {
        this.unbind();
    }

    private void callDestroyListeners() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        ArrayList listeners = this.manager.getListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
            for (int i = listeners.size() - 1; i >= 0; --i) {
                HttpSessionListener listener = (HttpSessionListener)listeners.get(i);
                listener.sessionDestroyed(event);
            }
        }
    }

    void setClosed() {
        this.isClosed = true;
    }

    void create(long now) {
        if (dbg.canWrite()) {
            dbg.log("create session " + this.id + " " + this.manager.getApplication());
        }
        if (this.isValid) {
            this.unbind();
        }
        this.isValid = true;
        this.isNew = true;
        this.accessTime = now;
        this.creationTime = now;
        this.hasChanged = false;
    }

    void reset(long now) {
        if (dbg.canWrite()) {
            dbg.log("reset session " + this.id + " " + this.manager.getApplication());
        }
        this.unbind();
        this.isValid = true;
        this.isNew = true;
        this.accessTime = now;
        this.creationTime = now;
        this.hasChanged = false;
    }

    public boolean needsLoad() {
        return this.needsLoad;
    }

    public void setNeedsLoad(boolean needsLoad) {
        this.needsLoad = needsLoad;
    }

    public void setBacking(ObjectBacking backing) {
        this.backing = backing;
    }

    public void passivate() {
        if (this.inUse) {
            ArrayList listeners = this.manager.getActivationListeners();
            for (int i = 0; listeners != null && i < listeners.size(); ++i) {
                HttpSessionActivationListener listener = (HttpSessionActivationListener)listeners.get(i);
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                listener.sessionWillPassivate(event);
            }
            this.unbind();
        }
    }

    public void unbind() {
        if (this.values == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.values.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            names.add(name);
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            Object value = null;
            value = this.values.remove(name);
            this.notifyValueUnbound(name, value);
        }
        this.values = null;
    }

    private void notifyValueUnbound(String name, Object oldValue) {
        ArrayList listeners;
        if (oldValue == null) {
            return;
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener listener = (HttpSessionBindingListener)oldValue;
            listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name, oldValue));
        }
        if ((listeners = this.manager.getAttributeListeners()) != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, oldValue);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.get(i);
                listener.attributeRemoved(event);
            }
        }
    }

    void setAccess(long now) {
        this.isNew = false;
        this.accessTime = now;
        this.inUse = true;
    }

    public void finish() {
        this.inUse = false;
        if (this.isValid && this.hasChanged && this.store != null && !this.manager.getSaveOnShutdown()) {
            this.hasChanged = this.manager.getAlwaysSaveSession();
            try {
                this.store.store(this);
            }
            catch (Throwable e) {
                Application app = this.manager.getApplication();
                app.log("Can't serialize session", e);
            }
        }
    }

    public void load(ObjectInputStream in) throws IOException {
        this.unbind();
        try {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                if (value == null) continue;
                this.setAttribute(key, value);
            }
        }
        catch (Exception e) {
            throw IOExceptionWrapper.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ObjectOutputStream out) throws IOException {
        Object object = this._lock;
        synchronized (object) {
            Set set = this.getEntrySet();
            int size = set == null ? 0 : set.size();
            out.writeInt(size);
            if (size == 0) {
                return;
            }
            boolean ignoreNonSerializable = this.getManager().getIgnoreSerializationErrors();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object value = entry.getValue();
                out.writeUTF((String)entry.getKey());
                if (ignoreNonSerializable && !(value instanceof Serializable)) {
                    out.writeObject(null);
                    continue;
                }
                try {
                    out.writeObject(value);
                }
                catch (NotSerializableException e) {
                    this.getServletContext().log(L.l("Failed storing persistent session attribute `{0}'.  Persistent session values must extend java.io.Serializable.\n{1}", entry.getKey(), String.valueOf(e)));
                    throw e;
                }
            }
        }
    }

    public DistributionServer getOwningServer() {
        int index = SessionManager.decode(this.id.charAt(0));
        return this.manager.getServer().getDistributionServer(index);
    }

    public DistributionServer getBackupServer() {
        int primaryIndex;
        ServletServer server = this.manager.getServer();
        DistributionServer owner = server.getDistributionServer(primaryIndex = SessionManager.decode(this.id.charAt(0)));
        DistributionServer[] group = owner.getGroup();
        int length = group.length;
        if (length <= 1) {
            return null;
        }
        int primaryGroup = owner.getGroupIndex();
        int secondaryOffset = SessionManager.decode(this.id.charAt(1)) % (length - 1);
        int secondaryIndex = (primaryGroup + secondaryOffset + 1) % length;
        return group[secondaryIndex];
    }

    String getMangledId() {
        if (this.mangledId != null) {
            return this.mangledId;
        }
        CharBuffer cb = CharBuffer.allocate();
        String str = this.manager.getApplication().getContextPath();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '/') {
                cb.append('_');
                continue;
            }
            cb.append(ch);
        }
        cb.append('_');
        cb.append(this.id);
        this.mangledId = cb.close();
        return this.mangledId;
    }

    Set getEntrySet() {
        if (!this.isValid) {
            throw new IllegalStateException(L.l("Can't call getEntrySet() when session is no longer valid."));
        }
        if (this.values != null) {
            return this.values.entrySet();
        }
        return null;
    }

    public boolean canLog() {
        return dbg.canWrite();
    }

    public void log(String value) {
        dbg.log(value);
    }

    public String toString() {
        return "[SessionImpl " + this.getId() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

