/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.server.RequestFactory;
import com.caucho.server.Server;
import com.caucho.server.ServerRequest;
import com.caucho.server.ShutdownListener;
import com.caucho.server.TcpConnection;
import com.caucho.util.Alarm;
import com.caucho.util.FreeList;
import com.caucho.util.QThreadLocal;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.WriteStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;

public class TcpServer
implements Runnable {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    private static WriteStream dbgThread = LogStream.open("/caucho.com/thread");
    private static long MS_PER_MINUTE = 60000L;
    private static long MS_PER_HOUR = 60L * MS_PER_MINUTE;
    private static long MS_PER_DAY = 24L * MS_PER_HOUR;
    private static int ACCEPT_BUFFER_SIZE = 256;
    private static QThreadLocal threadRequestMap;
    private FreeList freeConnections = new FreeList(8);
    private ThreadGroup threadGroup;
    private Thread thread;
    private Server server;
    private String protocolName;
    private RequestFactory requestFactory;
    private InetAddress socketAddress;
    private int socketPort;
    private QServerSocket serverSocket;
    private String virtualHost;
    private QSocket[] freeSockets = new QSocket[64];
    private int freeSocketsTop;
    private QSocket[] acceptRing;
    private volatile int acceptHead;
    private volatile int acceptTail;
    private final Object acceptLock = new Object();
    private StartThread startThread;
    private int acceptCount;
    private int threadAcceptMin = 5;
    private int threadAcceptMax = 10;
    private int startCount;
    private int socketCount;
    private boolean acceptIsBlocked;
    private Object keepaliveLock = new Object();
    private int keepaliveMax = 100;
    private int keepaliveCount;
    private long socketTimeout;
    private ArrayList connectionList = new ArrayList();
    private int connectionMax = 200;
    private int connectionCount;
    private Object threadPoolLock = new Object();
    private boolean enableBusy = true;
    private long lastKillTime = 0L;
    private long shutdownWaitTime = 10000L;
    private int busyCount;
    private long busyTime;
    private volatile boolean isStarted;
    private volatile boolean isClosed;
    private ShutdownListener shutdownListener;

    public TcpServer(RequestFactory requestFactory, QServerSocket serverSocket) throws Exception {
        this.threadGroup = new ThreadGroup("tcp-server");
        if (requestFactory == null) {
            throw new NullPointerException("null requestFactory");
        }
        if (serverSocket == null) {
            throw new NullPointerException("null serverSocket");
        }
        this.requestFactory = requestFactory;
        this.serverSocket = serverSocket;
        this.socketAddress = serverSocket.getLocalAddress();
        this.socketPort = serverSocket.getLocalPort();
    }

    public void init(Server server) {
        this.server = server;
        if (this.acceptRing == null) {
            this.acceptRing = new QSocket[ACCEPT_BUFFER_SIZE];
        }
        String name = "tcp-start-" + this.serverSocket.getLocalPort();
        this.startThread = new StartThread(this);
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        name = "tcp-accept-" + this.serverSocket.getLocalPort();
        this.thread = new Thread(this.threadGroup, this, name);
        this.thread.setDaemon(true);
        this.thread.start();
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Thread startupThread = new Thread(this.threadGroup, this.startThread, name);
        startupThread.setDaemon(true);
        startupThread.start();
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getProtocolName() {
        return this.requestFactory.getProtocolName();
    }

    public InetAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    public int getConnectionMax() {
        return this.connectionMax;
    }

    public void setConnectionMax(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("too few threads");
        }
        this.connectionMax = max;
        if (this.keepaliveMax >= max) {
            this.keepaliveMax = max - 2;
        }
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getKeepaliveMax() {
        return this.keepaliveMax;
    }

    public void setKeepaliveMax(int max) {
        if (max >= this.connectionMax) {
            throw new IllegalArgumentException("Keepalives can't exceed the maximum connections");
        }
        this.keepaliveMax = max;
    }

    public int getKeepaliveCount() {
        return this.keepaliveCount;
    }

    public int getThreadAcceptMin() {
        return this.threadAcceptMin;
    }

    public void setThreadAcceptMin(int max) {
        if (this.threadAcceptMin < 1) {
            throw new IllegalArgumentException("thread-min must be at least 1.");
        }
        this.threadAcceptMin = max;
    }

    public int getThreadAcceptMax() {
        return this.threadAcceptMax;
    }

    public void setThreadAcceptMax(int max) {
        if (this.threadAcceptMax < 1) {
            throw new IllegalArgumentException("thread-accept-max must be at least 1.");
        }
        this.threadAcceptMax = max;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public int getAcceptBufferSize() {
        if (this.acceptRing == null) {
            return ACCEPT_BUFFER_SIZE;
        }
        return this.acceptRing.length;
    }

    public void setAcceptBufferSize(int size) {
        this.acceptRing = size >= 4 ? new QSocket[size] : new QSocket[4];
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(long timeout) {
        this.socketTimeout = timeout;
    }

    public void setShutdownWaitTime(long waitTime) {
        this.shutdownWaitTime = waitTime;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public QServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean getEnableBusy() {
        return this.enableBusy;
    }

    public void setEnableBusy(boolean enableBusy) {
        this.enableBusy = enableBusy;
    }

    public void setShutdownListener(ShutdownListener listener) {
        this.shutdownListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exceptionCount = 0;
        int interruptCount = 0;
        this.isStarted = true;
        while (!this.isClosed) {
            try {
                int newHead = (this.acceptHead + 1) % this.acceptRing.length;
                QSocket socket = null;
                Object object = this.acceptLock;
                synchronized (object) {
                    if (this.freeSocketsTop > 0) {
                        socket = this.freeSockets[--this.freeSocketsTop];
                    }
                }
                socket = this.serverSocket.accept(socket);
                if (socket == null) continue;
                interruptCount = 0;
                while (newHead == this.acceptTail) {
                    object = this.startThread;
                    synchronized (object) {
                        this.startThread.notify();
                    }
                    object = this.acceptLock;
                    synchronized (object) {
                        this.acceptLock.notifyAll();
                        this.acceptIsBlocked = true;
                        try {
                            this.acceptLock.wait(500L);
                        }
                        catch (Exception e) {
                        }
                        finally {
                            this.acceptIsBlocked = false;
                        }
                    }
                }
                object = this.acceptLock;
                synchronized (object) {
                    this.acceptRing[this.acceptHead] = socket;
                    this.acceptHead = newHead;
                    ++this.socketCount;
                    try {
                        this.acceptLock.notify();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.acceptCount + this.startCount < this.socketCount) {
                    object = this.startThread;
                    synchronized (object) {
                        this.startThread.notify();
                    }
                }
                exceptionCount = 0;
                interruptCount = 0;
            }
            catch (InterruptedIOException e) {
                dbg.log(e);
                if (interruptCount++ <= 100) continue;
                if (dbg.canWrite()) {
                    dbg.log("closing because too many interrupts");
                }
                e.printStackTrace();
                this.close();
                break;
            }
            catch (Throwable e) {
                dbg.log(e);
                if (exceptionCount++ <= 100) continue;
                if (dbg.canWrite()) {
                    dbg.log("closing because too many exceptions");
                }
                e.printStackTrace();
                this.close();
                break;
            }
        }
        this.close();
        if (this.shutdownListener != null) {
            this.shutdownListener.handleShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionHasStarted() {
        Object object = this.acceptLock;
        synchronized (object) {
            --this.startCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QSocket accept(QSocket oldSocket) {
        boolean hasTimeout = false;
        Object object = this.acceptLock;
        synchronized (object) {
            if (oldSocket != null && this.freeSocketsTop < this.freeSockets.length) {
                this.freeSockets[this.freeSocketsTop++] = oldSocket;
            }
            while (!this.isClosed) {
                if (this.acceptHead != this.acceptTail) {
                    int newTail = (this.acceptTail + 1) % this.acceptRing.length;
                    QSocket socket = this.acceptRing[this.acceptTail];
                    --this.socketCount;
                    this.acceptTail = newTail;
                    if (this.acceptIsBlocked) {
                        this.acceptLock.notifyAll();
                    }
                    if (this.server.forbidConnection(socket)) {
                        try {
                            socket.close();
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                    return socket;
                }
                long now = Alarm.getCurrentTime();
                if (this.threadAcceptMax < this.acceptCount || this.threadAcceptMin < this.acceptCount && this.lastKillTime + 1000L < now && hasTimeout) {
                    this.lastKillTime = now;
                    return null;
                }
                ++this.acceptCount;
                try {
                    this.acceptLock.wait(5000L);
                    hasTimeout = true;
                }
                catch (Throwable e) {}
                continue;
                finally {
                    --this.acceptCount;
                }
            }
        }
        return null;
    }

    boolean isBusy() {
        return false;
    }

    int getBusyCount() {
        ++this.busyCount;
        long now = Alarm.getCurrentTime();
        if (this.busyTime + 60000L < now) {
            int count = this.busyCount;
            this.busyCount = 0;
            this.busyTime = now;
            return count;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocateKeepalive() {
        Object object = this.keepaliveLock;
        synchronized (object) {
            if (this.keepaliveCount >= this.keepaliveMax) {
                return false;
            }
            if (this.connectionCount >= this.connectionMax) {
                return false;
            }
            ++this.keepaliveCount;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeKeepalive() {
        Object object = this.keepaliveLock;
        synchronized (object) {
            --this.keepaliveCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanConnections() {
        ArrayList<TcpConnection> deadConnections = null;
        ArrayList arrayList = this.connectionList;
        synchronized (arrayList) {
            int newConnectionCount = 0;
            int len = this.connectionList.size();
            for (int i = len - 1; i >= 0; --i) {
                TcpConnection conn = (TcpConnection)this.connectionList.get(i);
                Thread thread = conn.getThread();
                if (thread == null || !thread.isAlive()) {
                    if (deadConnections == null) {
                        deadConnections = new ArrayList<TcpConnection>();
                    }
                    deadConnections.add(conn);
                    this.connectionList.remove(i);
                    continue;
                }
                ++newConnectionCount;
            }
            this.connectionCount = newConnectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startConnection() {
        boolean isStart;
        if (this.isClosed) {
            return false;
        }
        TcpConnection conn = null;
        ArrayList arrayList = this.connectionList;
        synchronized (arrayList) {
            if (this.connectionCount >= this.connectionMax) {
                return false;
            }
            ++this.connectionCount;
        }
        Object object = this.acceptLock;
        synchronized (object) {
            boolean bl = isStart = this.acceptCount + this.startCount <= this.socketCount;
            if (isStart) {
                ++this.startCount;
            } else if (this.connectionCount < this.acceptCount + this.startCount) {
                isStart = true;
                this.startCount = 1;
            }
        }
        if (!isStart) {
            object = this.connectionList;
            synchronized (object) {
                --this.connectionCount;
                return false;
            }
        }
        try {
            conn = null;
            if (conn == null) {
                ServerRequest request = this.requestFactory.createRequest(this.server);
                conn = new TcpConnection(this, request);
                if (this.virtualHost != null) {
                    conn.setVirtualHost(this.virtualHost);
                }
                ArrayList arrayList2 = this.connectionList;
                synchronized (arrayList2) {
                    this.connectionList.add(conn);
                }
            }
            String name = "tcpConnection-" + this.serverSocket.getLocalPort() + "-" + conn.getId();
            Thread thread = new Thread(this.threadGroup, conn, name);
            thread.setDaemon(true);
            conn.setThread(thread);
            thread.start();
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                this.isClosed = true;
            }
            Object object2 = this.acceptLock;
            synchronized (object2) {
                --this.startCount;
                if (this.startCount < 0) {
                    this.startCount = 0;
                }
            }
            dbgThread.log(e);
            e.printStackTrace(System.err);
            return false;
        }
        if (dbgThread.canWrite()) {
            dbgThread.log("start connection[" + conn.getId() + "] accept:" + this.acceptCount + " start:" + this.startCount + " keepalive:" + this.keepaliveCount + " total:" + this.connectionCount + " socket: " + this.socketCount + " ring:" + (this.acceptHead - this.acceptTail + this.acceptRing.length) % this.acceptRing.length);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopConnection(TcpConnection conn) {
        ArrayList arrayList = this.connectionList;
        synchronized (arrayList) {
            --this.connectionCount;
            this.connectionList.remove(conn);
        }
        if (dbgThread.canWrite()) {
            dbgThread.log("stop connection[" + conn.getId() + "] accept:" + this.acceptCount + " start:" + this.startCount + " keepalive:" + this.keepaliveCount + " total: " + this.connectionCount + " socket: " + this.socketCount + " ring:" + (this.acceptHead - this.acceptTail + this.acceptRing.length) % this.acceptRing.length);
        }
    }

    public boolean isDead() {
        Thread thread = this.thread;
        return this.isClosed || this.isStarted && thread != null && !thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object e2;
        block34: {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (dbg.canWrite()) {
                dbg.log("closing");
            }
            try {
                Object object = this.threadPoolLock;
                synchronized (object) {
                    this.threadPoolLock.notifyAll();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (this.serverSocket == null) break block34;
                e2 = this.serverSocket;
                synchronized (e2) {
                    this.serverSocket.notifyAll();
                }
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        try {
            e2 = this.acceptLock;
            synchronized (e2) {
                this.acceptLock.notifyAll();
            }
        }
        catch (Exception e4) {
            // empty catch block
        }
        try {
            e2 = this.startThread;
            synchronized (e2) {
                this.startThread.notifyAll();
            }
        }
        catch (Exception e5) {
            // empty catch block
        }
        int localPort = 0;
        if (this.serverSocket != null) {
            localPort = this.serverSocket.getLocalPort();
        }
        for (long i = 0L; i < 2L; ++i) {
            if (localPort > 0) {
                try {
                    Socket socket = new Socket("127.0.0.1", localPort);
                    socket.close();
                }
                catch (Exception e6) {
                    // empty catch block
                }
            }
            if (this.serverSocket != null) {
                try {
                    QServerSocket ss = this.serverSocket;
                    this.serverSocket = null;
                    ss.close();
                }
                catch (Exception e7) {
                    // empty catch block
                }
            }
            if (this.connectionCount == 0) {
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e8) {
                // empty catch block
            }
        }
    }

    static class StartThread
    implements Runnable {
        private TcpServer server;

        StartThread(TcpServer server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StartThread startThread = this;
            synchronized (startThread) {
                try {
                    this.wait(500L);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            do {
                try {
                    this.server.cleanConnections();
                    if (!this.server.startConnection() && !this.server.isDead()) {
                        startThread = this;
                        synchronized (startThread) {
                            try {
                                this.wait(10000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Throwable e) {
                    StartThread startThread2 = this;
                    dbg.log(e);
                }
            } while (!this.server.isDead());
        }
    }
}

